#include "RepeatColorNode.h"

RepeatColorNode::RepeatColorNode(
   int repeat, ColorNodeStack &theStack, int count
)
   : mRepeat(repeat), mCount(count), mNodes(0)
{
   mNodes = new const ColorNode *[mCount];

   for(int i = mCount - 1; i >= 0; i --)
      mNodes[i] = theStack.pop();
}

RepeatColorNode::~RepeatColorNode()
{
   // Sun's compiler warns that calling delete on a const object
   // isn't kosher

   for(int i = 0; i < mCount; i ++)
      delete (ColorNode *)mNodes[i];

   delete[] mNodes;
}

ostream &RepeatColorNode::print(ostream &out) const
{
   out << "repeat(" << mRepeat << ") { ";

   for(int i = 0; i < mCount; i ++)
      mNodes[i]->print(out);

   out << " }";

   return(out);
}

void RepeatColorNode::process(ColorTable &theTable) const
{
   for(int i = 0; i < mRepeat; i ++)
   {
      for(int j = 0; j < mCount; j ++)
         mNodes[j]->process(theTable);
   }
}
