// C/C++ Headers

#include <iostream.h>

// Local Headers

#include "UnaryComplexNode.h"

UnaryComplexNode::UnaryComplexNode(const ComplexNode *nodePtr)
: mComplexNodePtr(nodePtr) {}

UnaryComplexNode::~UnaryComplexNode()
{
   // Sun's compiler warns that calling delete on a const object
   // isn't kosher

   delete (ComplexNode *)mComplexNodePtr;
}

dcomplex UnaryComplexNode::evaluate() const
{
   return(-mComplexNodePtr->evaluate());
}

ostream &UnaryComplexNode::print(ostream &out) const
{
   out << "-";
   mComplexNodePtr->print(out);

   return(out);
}
