// C/C++ Headers

#include <iostream.h>

// Local Headers

#include "UnaryDoubleNode.h"

UnaryDoubleNode::UnaryDoubleNode(const DoubleNode *nodePtr)
   : mNodePtr(nodePtr) {}

UnaryDoubleNode::~UnaryDoubleNode()
{
   delete (DoubleNode *)mNodePtr;
}

double UnaryDoubleNode::evaluate() const
{
   return(-mNodePtr->evaluate());
}

ostream &UnaryDoubleNode::print(ostream &out) const
{
   out << "-";
   mNodePtr->print(out);

   return(out);
}
