// C/C++ Headers

#include <stdio.h>

// Local Headers

#include "messagehandler.h"

/*****************************************************************************
 * Declaration of class: DefaultMessageHandler
 *****************************************************************************/

class DefaultMessageHandler : public MessageHandler
{
   public:
      DefaultMessageHandler();
      ~DefaultMessageHandler();
      virtual MessageHandler *clone();
      void accept(const char *theMessage);
};

/*****************************************************************************
 * DefaultMessageHandler - methods
 *****************************************************************************/

DefaultMessageHandler::DefaultMessageHandler()
{
   // Nothing to do
}

DefaultMessageHandler::~DefaultMessageHandler()
{
   // Nothing to do
}

MessageHandler *DefaultMessageHandler::clone()
{
   return(new DefaultMessageHandler());
}

void DefaultMessageHandler::accept(const char *theMessage)
{
   printf("%s\n", theMessage);
}

/*****************************************************************************
 * MessageHandler - methods
 *****************************************************************************/

MessageHandler *MessageHandler::getDefaultHandler()
{
   return(new DefaultMessageHandler());
}
