#include "ColorsColorNode.h"

ColorsColorNode::ColorsColorNode(ColorNodeStack &theStack, int count) :
   mCount(count), mNodes(0)
{
   mNodes = new const ColorNode *[mCount];

   for(int i = mCount - 1; i >= 0; i --)
      mNodes[i] = theStack.pop();
}

ColorsColorNode::~ColorsColorNode()
{
   // Sun's compiler warns that calling delete on a const object
   // isn't kosher

   for(int i = 0; i < mCount; i ++)
      delete (ColorNode *)mNodes[i];

   delete[] mNodes;
}

ostream &ColorsColorNode::print(ostream &out) const
{
   for(int i = 0; i < mCount; i ++)
      mNodes[i]->print(out);

   return(out);
}

void ColorsColorNode::process(ColorTable &theTable) const
{
   for(int i = 0; i < mCount; i ++)
      mNodes[i]->process(theTable);
}
