#include "DefineColorNode.h"

DefineColorNode::DefineColorNode(
   int start, ColorNodeStack &theStack, int count
) : mNodes(0), mStart(start), mCount(count)
{
   acquireFromStack(theStack);
}

DefineColorNode::DefineColorNode(
   ColorNodeStack &theStack, int count
) : mNodes(0), mStart(NOT_SPECIFIED), mCount(count)
{
   acquireFromStack(theStack);
}

DefineColorNode::~DefineColorNode()
{
   // Sun's compiler warns that calling delete on a const object
   // isn't kosher

   for(int i = 0; i < mCount; i ++)
      delete (ColorNode *) mNodes[i];

   delete[] mNodes;
}

void DefineColorNode::acquireFromStack(ColorNodeStack &theStack)
{
   mNodes = new const ColorNode *[mCount];

   for(int i = mCount - 1; i >= 0; i --)
      mNodes[i] = theStack.pop();
}

ostream &DefineColorNode::print(ostream &out) const
{
   out << "define";

   if(mStart != NOT_SPECIFIED)
      out << "(" << mStart << ")";

   out << "{ ";

   for(int i = 0; i < mCount; i ++)
      mNodes[i]->print(out);

   out << " }";

   return(out);
}

void DefineColorNode::process(ColorTable &theTable) const
{
   if(mStart != NOT_SPECIFIED)
      theTable.setCurrentIndex(mStart);

   for(int i = 0; i < mCount; i ++)
      mNodes[i]->process(theTable);
}
