#include "GradientColorNode.h"
#include <stdlib.h>

GradientColorNode *GradientColorNode::create(
   int size, ColorStack &theStack, int count, strstream &errStream
)
{
   if(count < 2 || size < count)
   {
      errStream << "Illegal gradient requested\n"
                << "size of the gradient: [" << size << "]\n"
                << "colors in the gradient: [" << count << "]" << '\0';

      return(0);
   }

   return(new GradientColorNode(size, theStack, count));
}

GradientColorNode::GradientColorNode(
   int size, ColorStack &theStack, int count
) : mSize(size), mTable(0)
{
   // Acquire the colors to be used in our gradient

   const int **colors = new const int *[count];
   int i              = count - 1;

   while(i >= 0)
      colors[i--] = theStack.pop();

   double factor = (size - 1.0) / (count - 1.0);
   double delta[3] = { 0.0, 0.0, 0.0 };

   double low      = -factor;
   double high     = 0.0;
   int index       = -1;
   int j           = 0;

   mTable = new int *[size];

   for(i = 0; i < size; i ++)
   {
      if(i == 0 || i > high)
      {
         low  += factor;
         high += factor;
         index++;

         for(j = 0; j < 3; j ++)
            delta[j] = (colors[index + 1][j] - colors[index][j]);
      }

      mTable[i]    = new int[3];
      double value = (i - low) / factor;

      for(j = 0; j < 3; j ++)
         mTable[i][j] = (int)(colors[index][j] + delta[j] * value + 0.5);
   }

   for(i = 0; i < count; i ++)
      delete [] (int *)colors[i];

   delete[] colors;
}

GradientColorNode::~GradientColorNode()
{
   for(int i = 0; i < mSize; i ++)
      delete [] mTable[i];

   delete [] mTable;
}

ostream &GradientColorNode::print(ostream &out) const
{
   for(int i = 0; i < mSize; i ++)
   {
      if(i > 0) out << "\n";

      out << "entry[" << i << "] (" <<
         mTable[i][0] << ", " <<
         mTable[i][1] << ", " <<
         mTable[i][2] << ")";
   }

   return(out);
}

void GradientColorNode::process(ColorTable &theTable) const
{ 
   for(int i = 0; i < mSize; i ++)
      theTable.addEntry(mTable[i][0], mTable[i][1], mTable[i][2]);
}
