// C/C++ Headers

#include <iostream.h>

#include "TernaryDoubleNode.h"
#include "BooleanNode.h"

TernaryDoubleNode::TernaryDoubleNode(
   const BooleanNode *testPtr,
   const DoubleNode  *firstPtr,
   const DoubleNode  *secondPtr
)  :
   mTestPtr(testPtr),
   mFirstPtr(firstPtr),
   mSecondPtr(secondPtr)
{
}

TernaryDoubleNode::~TernaryDoubleNode()
{
   delete (BooleanNode *)mTestPtr;
   delete (DoubleNode *)mFirstPtr;
   delete (DoubleNode *)mSecondPtr;
}

double TernaryDoubleNode::evaluate() const
{
   return(
      mTestPtr->evaluate() ?
      mFirstPtr->evaluate() :
      mSecondPtr->evaluate()
   );
}

ostream &TernaryDoubleNode::print(ostream &out) const
{
   out << "(";
   mTestPtr->print(out);
   out << " ? ";
   mFirstPtr->print(out);
   out << " : ";
   mSecondPtr->print(out);
   out << ")";

   return(out);
}
