// C/C++ Headers

#include <iostream.h>

// Local Headers

#include "XorRegionNode.h"

XorRegionNode::XorRegionNode(
   const RegionNode *first, const RegionNode *second
)  :
   mFirst(first),
   mSecond(second)
{
}

XorRegionNode::~XorRegionNode()
{
   delete (RegionNode *)mFirst;
   delete (RegionNode *)mSecond;
}

int XorRegionNode::contains(const ComplexNode *point)  const
{
   int firstContains  = mFirst->contains(point);
   int secondContains = mSecond->contains(point);

   return(firstContains != secondContains);
}

ostream &XorRegionNode::print(ostream &out) const
{
   out << "r_xor(";
   mFirst->print(out);
   out << ", ";
   mSecond->print(out);
   return(out << ")");
}
