/* 
 * manipulstr.c -- 
 * SCCS Status     : %W%	%G%
 * Author          : Huynh Quoc T. Tung
 * Created On      : Sun Oct 17 16:43:35 1993
 * Last Modified By: Huynh Quoc T. Tung
 * Last Modified On: Sun Oct 17 16:43:38 1993
 * Update Count    : 1
 * Status          : Unknown, Use with caution!
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "cutil.h"

#define LITERAL_KEY1	'"'   
#define LITERAL_KEY2	0x27    /* single quote ' dgg */
#define MAX_WORD_LENGTH 20
#define MAX_LINE_LENGTH 1000 

/* HQTT, 5.10.93  */
long number_of_qwords = 0;

struct string_node
{ 
  char key[4]; 
  struct string_node *next;
};

static struct string_node *head_string, *z_string, *t_string;

static string_stackinit _AP(());
static string_stackinit()
{
  head_string = (struct string_node *)malloc(sizeof (struct string_node));
  z_string = (struct string_node *)malloc(sizeof(struct string_node));
  head_string->next = z_string; 
  head_string->key[0] = '\0' ; 
  z_string->next = z_string;
}

static string_push _AP((char* string));
static string_push(string)
     char* string;
{
  t_string = (struct string_node *)malloc(sizeof(struct string_node));
  s_strncpy(t_string->key, string, strlen(string)+1);
  t_string->next = head_string->next;
  head_string->next = t_string;
}

static char* string_pop _AP(());
static char* string_pop()
{
  char* x_string;

  t_string = head_string->next;
  head_string->next = t_string->next;
  x_string = t_string->key;
  free(t_string);
  return(x_string);
}

static int string_stackempty _AP(());
static int string_stackempty()
{
  return(head_string->next == z_string);
}


static char* infix_to_postfix _AP((char* line));
static char* infix_to_postfix(line)
     char *line;
{
  char* word;
  char* result;
  char* cpy_line;
  int parentheses_count = 0;
  int operand_count = 0;
  int literal_count = 0;

  cpy_line = (char *)s_malloc((strlen(line) + 1) * sizeof(char));
  result = (char *)s_malloc((strlen(line) + 1) * sizeof(char));
  result[0] = '\0' ;
  cpy_line[0] = '\0' ;
  s_strncpy(cpy_line, line, strlen(line)+1);
  word = strtok(cpy_line, " ");
  string_stackinit(); 
  while(word != NULL) {
    if(!strcmp(word, "(")) {
      ++parentheses_count;
      operand_count = 0;
    }
    if(!strcmp(word, ")")) {
      --parentheses_count;
      if(!string_stackempty()) {
        s_strncat(result, string_pop(), MAX_LINE_LENGTH, MAX_LINE_LENGTH);
        s_strncat(result, " ", MAX_LINE_LENGTH, MAX_LINE_LENGTH);
      }
      if((parentheses_count == 0) && !string_stackempty()) {
        s_strncat(result, string_pop(), MAX_LINE_LENGTH, MAX_LINE_LENGTH);
        s_strncat(result, " ", MAX_LINE_LENGTH, MAX_LINE_LENGTH);
      }
      operand_count = 1;
    }
    else if(!strcmp(word, "or") && (literal_count == 0)) {
      if(operand_count == 2) {
        if(!string_stackempty()) {
          s_strncat(result, string_pop(), MAX_LINE_LENGTH, MAX_LINE_LENGTH);
          s_strncat(result, " ", MAX_LINE_LENGTH, MAX_LINE_LENGTH);
          operand_count = 1;
        }
      }
      string_push(word);
    }
    else if(!strcmp(word, "and") && (literal_count == 0)) {
      if(operand_count == 2) {
        if(!string_stackempty()) {
          s_strncat(result, string_pop(), MAX_LINE_LENGTH, MAX_LINE_LENGTH);
          s_strncat(result, " ", MAX_LINE_LENGTH, MAX_LINE_LENGTH);
          operand_count = 1;
        }
      }
      string_push(word);
    }
    else if(!strcmp(word, "not") && (literal_count == 0)) {
      if(operand_count == 2) {
        s_strncat(result, string_pop(), MAX_LINE_LENGTH, MAX_LINE_LENGTH);
        s_strncat(result, " ", MAX_LINE_LENGTH, MAX_LINE_LENGTH);
        operand_count = 1;
      }
      string_push(word); 
    }
    else if (strcmp(word, "(")){
      s_strncat(result, word, MAX_LINE_LENGTH, MAX_LINE_LENGTH);
      s_strncat(result, " ", MAX_LINE_LENGTH, MAX_LINE_LENGTH);
      if(!strcmp(word,"soundex") || !strcmp(word,"phonix")) ;
      else if(((word[0] == LITERAL_KEY1) && 
               (word[strlen(word)-1] == LITERAL_KEY1)) ||
              ((word[0] == LITERAL_KEY2) && 
               (word[strlen(word)-1] == LITERAL_KEY2))) {
        ++operand_count;
        ++number_of_qwords; 
      }
      else if(((word[0] == LITERAL_KEY1) && 
               (word[strlen(word)-1] != LITERAL_KEY1)) ||
              ((word[0] == LITERAL_KEY2) && 
               (word[strlen(word)-1] != LITERAL_KEY2))) {
        literal_count = 1;
      }
      else if(((word[0] != LITERAL_KEY1) &&
               (word[strlen(word)-1] == LITERAL_KEY1) &&
               (literal_count == 1)) ||
              ((word[0] != LITERAL_KEY2) && 
               (word[strlen(word)-1] == LITERAL_KEY2) &&
               (literal_count == 1))) {
        ++operand_count;
        ++number_of_qwords;
        literal_count = 0;
      }
      else {
        if(literal_count == 0) {
          ++operand_count;
          ++number_of_qwords;
        }
      }
    }
    word = strtok(NULL, " ");
  }
  while(!string_stackempty()) { 
    s_strncat(result, string_pop(), MAX_LINE_LENGTH, MAX_LINE_LENGTH);
    s_strncat(result, " ", MAX_LINE_LENGTH, MAX_LINE_LENGTH);
  }
  s_free(cpy_line);
  return(result);

}

char *string_manipulation(line)
     char *line;
{
  int char_count, char_count_of_newline;
  char ch;
  char *word;
  char newline[MAX_LINE_LENGTH+1];
  boolean parentheses = false;
  boolean special_chr = false;
  char_count = char_count_of_newline = 0;

  for(ch = line[char_count++]; 
      ch != '\0'; ch = line[char_count++]){
    if(isalnum(ch) && !special_chr) {
      newline[char_count_of_newline++] = ch;
      parentheses = false;
    }
    else if(isspace(ch) || (ch == '\t') || (ch == '\n')) 
      special_chr = true;
    else if(isalnum(ch) && special_chr) {
      newline[char_count_of_newline++] = ' ';
      newline[char_count_of_newline++] = ch;
      special_chr = false;
      parentheses = false;
    }
    else if((ch == '(') || (ch == ')')) {
      newline[char_count_of_newline++] = ' ';
      newline[char_count_of_newline++] = ch;
      parentheses = true;
      special_chr = true;
    }
    else {
      if(parentheses) {
        newline[char_count_of_newline++] = ' ';
	newline[char_count_of_newline++] = ch;
	special_chr = false;
	parentheses = false;
      }
      else {
        if(special_chr) {
          newline[char_count_of_newline++] = ' ';
          newline[char_count_of_newline++] = ch;
        }
        else
          newline[char_count_of_newline++] = ch;
	special_chr = false;
      } 
    }
  }
  newline[char_count_of_newline] = '\0';
  s_strncpy(newline, infix_to_postfix(newline), MAX_LINE_LENGTH);
  return(newline);
}   

  
