/*-
 ***********************************************************************
 *
 * $Id: ssl-pool.h,v 1.5 2006/04/07 22:15:11 mavrik Exp $
 *
 ***********************************************************************
 *
 * Copyright 2002-2006 Klayton Monroe, All Rights Reserved.
 *
 ***********************************************************************
 */

/*
 ***********************************************************************
 *
 * Defines
 *
 ***********************************************************************
 */
#define SSL_POOL_SEED 0x00000000
#define SSL_POOL_SIZE 0x00008000
#define SSL_POOL_TAPS (0) + (1)


/*
 ***********************************************************************
 *
 * Macros
 *
 ***********************************************************************
 */
#define SSL_NEW_POOL(aucPool, iLength, ulState)\
{\
  int i, j;\
  unsigned long ul = ulState;\
  for (i = 0; i < iLength; i++)\
  {\
    for (j = 0, aucPool[i] = 0; j < 8; j++)\
    {\
      aucPool[i] |= (ul & 1) << j;\
      ul = ((((ul >> 7) ^ (ul >> 6) ^ (ul >> 2) ^ (ul >> 0)) & 1) << 31) | (ul >> 1);\
    }\
  }\
}

#define SSL_TAP_POOL(aucTaps, aucPool)\
{\
  aucTaps[0] = 0;\
}
