#!/usr/bin/env python

import Tkinter, sys, os, string
from pygale import *

XML = """<?xml version="1.0"?>
<fuguconfig>
<preferences>
	<sender>%(sender)s</sender>
	<signer>%(signer)s</signer>
	<buffersize>200</buffersize>
	<urlcommand>netscape -remote openURL(%%s)</urlcommand>
	<thumbnails on="%(imagecreate)s"/>
	<thumbnail-url></thumbnail-url>
	<ccself on="no"/>
	<autocomplete on="yes"/>
	<broadcast-presence on="yes"/>
	<keyword-prompt on="yes"/>
	<cursorcolor>#00ffff</cursorcolor>
	<buttonbar on="yes"/>
	<presence-list>
		<presence>in/perhaps</presence>
		<presence>out/somewhere/else</presence>
	</presence-list>
	<default-presence>in/perhaps</default-presence>
	<pane-height>700</pane-height>
	<pane-top>500</pane-top>
	<pane-bottom>200</pane-bottom>
	<pane-width>-1</pane-width>
	<save-pane-width on="yes"/>
	<persist-pufflog on="yes" interval="300"/>
</preferences>

<screen>
	<name>Public</name>
	<subscription>%(publicsub)s</subscription>
	<savehistory on="yes"/>
	<logsent>0</logsent>
	<send-receipts on="no"/>
	<onpuff>
		<beep on="no"/>
		<highlight-button on="yes"/>
		<lift-screen on="no"/>
		<deiconify on="no"/>
		<command on="no"></command>
	</onpuff>
</screen>

<screen>
	<name>Private</name>
	<subscription>%(privatesub)s</subscription>
	<savehistory on="yes"/>
	<logsent>1</logsent>
	<send-receipts on="yes"/>
	<onpuff>
		<beep on="yes"/>
		<highlight-button on="yes"/>
		<lift-screen on="no"/>
		<deiconify on="no"/>
		<command on="no"></command>
	</onpuff>
</screen>

<screen>
	<name>Watch</name>
	<subscription>%(watchsub)s</subscription>
	<savehistory on="no"/>
	<logsent>0</logsent>
	<send-receipts on="no"/>
	<onpuff>
		<beep on="no"/>
		<highlight-button on="no"/>
		<lift-screen on="no"/>
		<deiconify on="no"/>
		<command on="no"></command>
	</onpuff>
</screen>

</fuguconfig>"""

# Helper func for config class
def get_my_fullname():
	if sys.platform == 'win32':
		return gale_env.get('GALE_FROM', 'Fugu user')
	else:
		import pwd, string
		name = pwd.getpwuid(os.getuid())[4]
		if "," in name:
			name = name[:string.index(name, ',')]
		if not name:
			name = 'Fugu user'
		return name

def getXML():
	sender = get_my_fullname()
	signer = pygale.gale_user()
	try:
		import xml.sax.saxutils
		sender = xml.sax.saxutils.escape(sender)
		signer = xml.sax.saxutils.escape(signer)
	except ImportError:
		import re
		sender = re.sub('&', '&amp;', sender)
		sender = re.sub('<', '&lt;', sender)
		sender = re.sub('>', '&gt;', sender)
		sender = re.sub('"', '&quot;', sender)
		sender = re.sub("'", '&apos;', sender)
		signer = re.sub('&', '&amp;', signer)
		signer = re.sub('<', '&lt;', signer)
		signer = re.sub('>', '&gt;', signer)
		signer = re.sub('"', '&quot;', signer)
		signer = re.sub("'", '&apos;', signer)

	publicsub = pygale.gale_env.get('GALE_SUBSCRIBE', 'new@gale.org')
	privatesub = signer
	watchsub = '_gale.notice@' + pygale.gale_domain()
	imagecreate = ['no', 'yes'][hasattr(Tkinter.Text, 'image_create')]

	return XML % locals()
