#!/usr/bin/env python

# This code courtesy of Peter Haight <peterh@sapros.com>

import Tkinter

class ButtonBar(Tkinter.Frame):
	def __init__(self, master = None, cnf = {}, **kw):
		cnf = Tkinter._cnfmerge((cnf, kw))
		Tkinter.Frame.__init__(self, master, cnf)
		self.buttons = []
		self.bind('<Configure>', self.configure_event)
		self.padx = 4
		self.pady = 0
		
		
	def configure_event(self, event):
		self.layout()
		
		
	def add_button(self, button, index=None):
		button.bind('<Configure>', self.configure_event)
		if index is not None:
			self.buttons.insert(index, button)
		else:
			self.buttons.append(button)
		self.layout()

	def del_button(self, button):
		button.place_forget()
		index = self.buttons.index(button)
		del self.buttons[index]
		self.layout()
		
	def layout(self):
		width = self.winfo_width()
		cur_x = self.padx
		cur_y = self.pady
		for button in self.buttons:
			if (cur_x != self.padx and  
			    cur_x + button.winfo_reqwidth() > width):
				cur_y = cur_y + \
				        button.winfo_reqheight() + self.pady
				cur_x = self.padx
			button.place(x = cur_x, y = cur_y)
			cur_x = cur_x + button.winfo_reqwidth() + self.padx
		if cur_x != self.padx:
			cur_y = cur_y + button.winfo_reqheight() + self.pady
		self.configure(height = cur_y)



def _test():
	root = Tkinter.Tk()
	button_bar = ButtonBar(root, background = 'red', width = 100)
	for i in range(0, 10):
		button = Tkinter.Button(button_bar, text = '%d' % (i))
		button_bar.add_button(button)
#	button_bar.place(x = 0, y = 0, relwidth = 1, relheight = 1)
	button_bar.pack(side = Tkinter.TOP, anchor = 'nw', fill = 'x')
	button_bar.update()
	button_bar.layout()
	frame = Tkinter.Frame(root, background = 'blue')
	frame.pack(side = Tkinter.BOTTOM, anchor = 'nw', expand = 1, 
		   fill = Tkinter.BOTH)
	root.mainloop()
	
	
if __name__ == '__main__':
	_test()
