#!/uns/bin/python

from Tkinter import *
from ScrolledText import *
import time, re, string

BOLD_FONT = 'Times 12 bold'

class PuffDisp(Toplevel):
	def __init__(self, puff):
		Toplevel.__init__(self)
		self._puff = puff
		self._create_widgets()
		self.protocol('WM_DELETE_WINDOW', self.close)
		self.title(puff.get_loc())
	
	def _create_widgets(self):
		puff = self._puff
		self._text = ScrolledText(self, height=10,
			selectforeground='white', selectbackground='black',
			selectborderwidth=0, wrap='word')
		self._text.tag_configure('bold', font=BOLD_FONT)
		self._text.insert('end', puff.get_text_first('message/sender',
			'Unknown sender'), 'bold')
		self._text.insert('end', ' to %s\n\n' % 
			string.join(string.split(puff.get_loc(), None), ', '))

		pufftext = re.sub('\r\n', '\n',
			puff.get_text_first('message/body', ''))
		self._text.insert('end', pufftext)
		timeint = puff.get_time_first('id/time', time.time())
		self._text.insert('end', '\nSent by %s at %s' %
			(puff.get_signer('*unverified*'),
			time.strftime('%m-%d %H:%M:%S', time.localtime(timeint))))
		self._text['state'] = 'disabled'
		self._text.pack(side=TOP, expand=1, fill=BOTH)
		self._closebutton = Button(self, text='Close',
			command=self.close)
		self._closebutton.pack(side=BOTTOM, fill=X, expand=0)
	
	def close(self):
		self.destroy()
