#!/usr/bin/env python

import sys, string, os
try:
        import distutils
except ImportError:
	print
	print '*** ERROR! ***'
	print 'Unable to import Python Distribution Utilities'
	print 'Either upgrade to Python 2.0 or better, or install'
	print 'the distutils before installing Fugu:'
	print '    http://www.python.org/sigs/distutils-sig/download.html'
	sys.exit(-1)
from distutils.core import setup, Extension

def have_swig():
	# This really only works on unix; it should be implemented in
	# distutils itself, really
	# Yucky hack
	swig_output = os.popen('swig -version 2>&1', 'r').read()
	if string.find(swig_output, 'SWIG Version 1.1') != -1:
		return 1
	else:
		return 0

sub_module_names = \
[
	'bn',
	'err',
	'evp',
	'rand',
	'rsa',
]

if sys.platform == 'win32':
	include_dirs = ['/peterh/ext/openssl-0.9.6a/inc32']
	library_dirs = ['/peterh/ext/openssl-0.9.6a/out32dll']
	libraries = ['libeay32']
else:
	include_dirs = ['/home/tlau/Python-2.1.1/Include']
	library_dirs = ['/home/tlau/Python-2.1.1/Lib']
	libraries = ['crypto']

extensions = []
source_files = []
if have_swig():
	extension = '.i'
else:
	extension = '.c'
for module_name in sub_module_names:
	source_files.append('src/%sc%s' % (module_name, extension))
source_files.append('src/opensslc.c')
new_extension = Extension('opensslc', source_files, 
			  include_dirs = include_dirs, 
			  library_dirs = library_dirs, libraries = libraries)
extensions.append(new_extension)

setup (name = "py-openssl",
       version = "0.1",
       description = "Python OpenSSL Interface",
       author = "Peter Haight",
       author_email = "peterh@sapros.com",
       url = "http://www.sapros.com/py-openssl",
       ext_package = 'openssl',
       packages = ['openssl'],
       package_dir = {'openssl' : 'src'},
       ext_modules = extensions
      )


