#
# $Id: bnc.i,v 1.1 2001/07/12 05:47:15 tlau Exp $
#
%module bnc

%pragma make_default

%{
#include "openssl/bn.h"
%}


typedef struct {} BIGNUM;

%typemap(python, in) const unsigned char * 
{
	if (PyString_Check($source)) 
	{
		$target = PyString_AsString($source);
	} 
	else 
	{
		PyErr_SetString(PyExc_TypeError, "expected a string");
		return NULL;
	}
}

%typemap(python, in) BIGNUM *ret
{
	char *return_bignum_name;

	if ($source == Py_None)
	{
		$target = NULL;
	}
	else
	{
		return_bignum_name = PyString_AsString($source);
		if (SWIG_GetPtr(return_bignum_name,(void **) &$target,"_BIGNUM_p")) {
			PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of BN_bin2bn. Expected _BIGNUM_p.");
			return NULL;
		}
	}
}

%{
void
python_BN_print(BIGNUM* bn)
{
	BN_print_fp(stdout, bn);
}
%}

BIGNUM *BN_bin2bn(const unsigned char *s,int len,BIGNUM *ret);
BIGNUM *BN_new(void);
void	BN_free(BIGNUM* bn);
void	python_BN_print(BIGNUM* bn);
