/*
 * FILE : src/evpc.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header: /ofb/cvs/fugu/py-openssl/src/evpc.c,v 1.1 2001/09/02 00:56:56 tlau Exp $
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log: evpc.c,v $
 * Revision 1.1  2001/09/02 00:56:56  tlau
 * Added sources to be able to build without SWIG
 *
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header: /ofb/cvs/fugu/py-openssl/src/evpc.c,v 1.1 2001/09/02 00:56:56 tlau Exp $
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initevpc

#define SWIG_name    "evpc"

#include "openssl/ssl.h"

typedef union {
		char *ptr;
		RSA *rsa;	/* RSA */
		struct dsa_st *dsa;	/* DSA */
		struct dh_st *dh;	/* DH */
	} EVP_PKEY_pkey;


EVP_MD_CTX* 
EVP_MD_CTX_new(void)
{
	return (EVP_MD_CTX*) malloc(sizeof(EVP_MD_CTX));
}

void
EVP_MD_CTX_free(EVP_MD_CTX* ctx)
{
	if (ctx != NULL)
	{
		free(ctx);
	}
}

PyObject*
python_EVP_SignFinal(EVP_MD_CTX* ctx, EVP_PKEY* pkey)
{
	PyObject* python_string;
	PyObject* return_obj;
	char* buf;
	int buf_len;
	int result;

	buf_len = EVP_PKEY_size(pkey);
	python_string = PyString_FromStringAndSize(NULL, buf_len);
	if (python_string == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for SignFinal buffer.");
		return NULL;
	}
	buf = PyString_AsString(python_string);
	result = EVP_SignFinal(ctx, buf, &buf_len, pkey);
	if (result == 0)
	{
		Py_DECREF(python_string);
		python_string = Py_None;
		Py_INCREF(python_string);
	}
	else
	{
		_PyString_Resize(&python_string, buf_len);
	}

	return_obj = Py_BuildValue("O", python_string);
	Py_DECREF(python_string);

	return return_obj;
}

EVP_CIPHER_CTX* 
EVP_CIPHER_CTX_new(void)
{
	return (EVP_CIPHER_CTX*) malloc(sizeof(EVP_CIPHER_CTX));
}

void
EVP_CIPHER_CTX_free(EVP_CIPHER_CTX* ctx)
{
	if (ctx != NULL)
	{
		free(ctx);
	}
}

PyObject*
python_EVP_SealInit(EVP_CIPHER_CTX* ctx, EVP_CIPHER* type, PyObject* public_keys)
{
	int i;
	int num_public_keys = 0;
	EVP_PKEY** evp_public_keys = NULL;
	PyObject* pkey_object = NULL;
	PyObject* pkey_object_name = NULL;
	EVP_PKEY* pkey = NULL;
	int encrypted_key_buf_len = 0;
	char** buffers = NULL;
	int* buffer_lengths = NULL;
	PyObject** python_strings = NULL;
	PyObject* python_iv_string = NULL;
	char* iv_buf = NULL;
	PyObject* return_list;
	PyObject* return_object = NULL;
	int result;

	num_public_keys = PyList_Size(public_keys);
	evp_public_keys = (EVP_PKEY**) malloc(sizeof(EVP_PKEY*) * num_public_keys);
	if (evp_public_keys == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
		return NULL;
	}
	buffers = (char **) malloc(sizeof(char*) * num_public_keys);
	if (buffers == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
		goto error_cleanup;
	}
	python_strings = (PyObject **) malloc(sizeof(PyObject*) * num_public_keys);
	if (python_strings == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
		goto error_cleanup;
	}
	buffer_lengths = (int *) malloc(sizeof(int) * num_public_keys);
	if (buffer_lengths == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
		goto error_cleanup;
	}

	for (i = 0; i < num_public_keys; ++i)
	{
		python_strings[i] = NULL;
		pkey_object = PyList_GetItem(public_keys, i);
		pkey_object_name = PyObject_GetAttrString(pkey_object, "ptr");
		if (SWIG_GetPtr(PyString_AsString(pkey_object_name), (void**) &pkey, "_EVP_PKEY_p"))
		{
			PyErr_SetString(PyExc_TypeError, "Type error in list of public keys. Each item should be a evp.PKEY instance.");
			goto error_cleanup;
		}
		evp_public_keys[i] = pkey;
		encrypted_key_buf_len = EVP_PKEY_size(pkey);
		python_strings[i] = PyString_FromStringAndSize(NULL, encrypted_key_buf_len);
		if (python_strings[i] == NULL)
		{
			PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
			goto error_cleanup;
		}
		buffers[i] = PyString_AsString(python_strings[i]);
	}
	python_iv_string = PyString_FromStringAndSize(NULL, EVP_MAX_IV_LENGTH);
	if (python_iv_string == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
		goto error_cleanup;
	}
	iv_buf = PyString_AsString(python_iv_string);
	result = EVP_SealInit(ctx, type, (unsigned char**) buffers, buffer_lengths, iv_buf,
			      evp_public_keys, num_public_keys);
	if (result != 0)
	{
		return_list = PyList_New(num_public_keys);
		for (i = 0; i < num_public_keys; ++i)
		{
			_PyString_Resize(&python_strings[i], buffer_lengths[i]);
			PyList_SetItem(return_list, i, python_strings[i]);
		}
		return_object = Py_BuildValue("OO", python_iv_string, return_list);
		Py_DECREF(return_list);
		Py_DECREF(python_iv_string);
		goto cleanup;
	}

error_cleanup:
	for (i = 0; i < num_public_keys; ++i)
	{
		if (python_strings[i] != NULL)
		{
			Py_DECREF(python_strings[i]);
		}
	}
	Py_DECREF(python_iv_string);

cleanup:
	free(evp_public_keys);
	free(buffers);
	free(python_strings);
	free(buffer_lengths);

	return return_object;
}

PyObject*
python_EVP_SealUpdate(EVP_CIPHER_CTX* ctx, PyObject* unencrypted_data)
{
	int encrypted_data_len;
	PyObject* encrypted_python_string;
	PyObject* return_obj;
	char* encrypted_data_buf;
	char* unencrypted_data_buf;
	int unencrypted_data_len;

	unencrypted_data_buf = PyString_AsString(unencrypted_data);
	unencrypted_data_len = PyString_Size(unencrypted_data);

	encrypted_data_len = PyString_Size(unencrypted_data) + EVP_CIPHER_CTX_block_size(ctx) - 1;
	encrypted_python_string = PyString_FromStringAndSize(NULL, encrypted_data_len);
	if (encrypted_python_string == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
		return NULL;
	}
	encrypted_data_buf = PyString_AsString(encrypted_python_string);

	/* Version 0.9.5a of OpenSSL does not return a value from SealUpdate,
	 * whereas 0.9.6 returns an int.  Ignore the return value and always
	 * assume success---this could expose a bug.
	 */
	EVP_SealUpdate(ctx, encrypted_data_buf, &encrypted_data_len, unencrypted_data_buf, unencrypted_data_len);
	_PyString_Resize(&encrypted_python_string, encrypted_data_len);
	
	return_obj = Py_BuildValue("O", encrypted_python_string);
	Py_DECREF(encrypted_python_string);
	
	return return_obj;
}

PyObject*
python_EVP_SealFinal(EVP_CIPHER_CTX* ctx)
{
	int encrypted_data_len;
	PyObject* encrypted_python_string;
	PyObject* return_obj;
	char* encrypted_data_buf;

	encrypted_data_len = EVP_CIPHER_CTX_block_size(ctx) - 1;
	encrypted_python_string = PyString_FromStringAndSize(NULL, encrypted_data_len);
	if (encrypted_python_string == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for encrypted key buffers.");
		return NULL;
	}
	encrypted_data_buf = PyString_AsString(encrypted_python_string);

	EVP_SealFinal(ctx, encrypted_data_buf, &encrypted_data_len);
	_PyString_Resize(&encrypted_python_string, encrypted_data_len);

	return_obj = Py_BuildValue("O", encrypted_python_string);
	Py_DECREF(encrypted_python_string);
	
	return return_obj;
}

PyObject*
python_EVP_OpenUpdate(EVP_CIPHER_CTX* ctx, PyObject* encrypted_data)
{
	PyObject* unencrypted_python_string;
	PyObject* return_obj;
	char* unencrypted_data_buf;
	int unencrypted_data_len;
	char* encrypted_data_buf;
	int encrypted_data_len;

	encrypted_data_buf = PyString_AsString(encrypted_data);
	encrypted_data_len = PyString_Size(encrypted_data);

	unencrypted_data_len = PyString_Size(encrypted_data) + EVP_CIPHER_CTX_block_size(ctx) - 1;
	unencrypted_python_string = PyString_FromStringAndSize(NULL, unencrypted_data_len);
	if (unencrypted_python_string == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for unencrypted buffers.");
		return NULL;
	}
	unencrypted_data_buf = PyString_AsString(unencrypted_python_string);

	EVP_OpenUpdate(ctx, unencrypted_data_buf, &unencrypted_data_len, encrypted_data_buf, encrypted_data_len);
	_PyString_Resize(&unencrypted_python_string, unencrypted_data_len);
	
	return_obj = Py_BuildValue("O", unencrypted_python_string);
	Py_DECREF(unencrypted_python_string);
	
	return return_obj;
}

PyObject*
python_EVP_OpenFinal(EVP_CIPHER_CTX* ctx)
{
	PyObject* unencrypted_python_string;
	PyObject* return_obj;
	char* unencrypted_data_buf;
	int unencrypted_data_len;
	char* encrypted_data_buf;
	int encrypted_data_len;
	int result;

	unencrypted_data_len = EVP_CIPHER_CTX_block_size(ctx);
	unencrypted_python_string = PyString_FromStringAndSize(NULL, unencrypted_data_len);
	if (unencrypted_python_string == NULL)
	{
		PyErr_SetString(PyExc_MemoryError, "Unable to allocate memory for unencrypted buffers.");
		return NULL;
	}
	unencrypted_data_buf = PyString_AsString(unencrypted_python_string);

	result = EVP_OpenFinal(ctx, unencrypted_data_buf, &unencrypted_data_len);
	if (result == 0)
	{
		Py_DECREF(unencrypted_python_string);
		unencrypted_python_string = Py_None;
		Py_INCREF(unencrypted_python_string);
	}
	else
	{
		_PyString_Resize(&unencrypted_python_string, unencrypted_data_len);
	}
	
	return_obj = Py_BuildValue("O", unencrypted_python_string);
	Py_DECREF(unencrypted_python_string);
	
	return return_obj;
}

static PyObject *_wrap_EVP_PKEY_assign_RSA(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    RSA * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_PKEY_assign_RSA",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_assign_RSA. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_RSA_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_PKEY_assign_RSA. Expected _RSA_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_assign_RSA(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_EVP_PKEY_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_PKEY * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":EVP_PKEY_new")) 
        return NULL;
    _result = (EVP_PKEY *)EVP_PKEY_new();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_PKEY_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_EVP_PKEY_free(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_free",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_free. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    EVP_PKEY_free(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_md5(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":EVP_md5")) 
        return NULL;
    _result = (EVP_MD *)EVP_md5();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_MD_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_EVP_des_ede3_cbc(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_CIPHER * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":EVP_des_ede3_cbc")) 
        return NULL;
    _result = (EVP_CIPHER *)EVP_des_ede3_cbc();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_CIPHER_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_EVP_MD_CTX_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":EVP_MD_CTX_new")) 
        return NULL;
    _result = (EVP_MD_CTX *)EVP_MD_CTX_new();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_MD_CTX_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_EVP_MD_CTX_free(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_MD_CTX_free",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_MD_CTX_free. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
    EVP_MD_CTX_free(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_SignInit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _arg0;
    EVP_MD * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_SignInit",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_SignInit. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_EVP_MD_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_SignInit. Expected _EVP_MD_p.");
        return NULL;
        }
    }
    EVP_SignInit(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_SignUpdate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _arg0;
    unsigned char * _arg1;
    unsigned int  _arg2;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOi:EVP_SignUpdate",&_argc0,&_obj1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_SignUpdate. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    EVP_SignUpdate(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_SignFinal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_MD_CTX * _arg0;
    unsigned char * _arg1;
    unsigned int * _arg2;
    EVP_PKEY * _arg3;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOss:EVP_SignFinal",&_argc0,&_obj1,&_argc2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_SignFinal. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_unsigned_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of EVP_SignFinal. Expected _unsigned_int_p.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of EVP_SignFinal. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_SignFinal(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_python_EVP_SignFinal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    EVP_MD_CTX * _arg0;
    EVP_PKEY * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:python_EVP_SignFinal",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of python_EVP_SignFinal. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of python_EVP_SignFinal. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (PyObject *)python_EVP_SignFinal(_arg0,_arg1);
{
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_EVP_SealInit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_CIPHER_CTX * _arg0;
    EVP_CIPHER * _arg1;
    unsigned char ** _arg2;
    int * _arg3;
    unsigned char * _arg4;
    EVP_PKEY ** _arg5;
    int  _arg6;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char * _argc2 = 0;
    char * _argc3 = 0;
    PyObject * _obj4 = 0;
    char * _argc5 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssssOsi:EVP_SealInit",&_argc0,&_argc1,&_argc2,&_argc3,&_obj4,&_argc5,&_arg6)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_SealInit. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_EVP_CIPHER_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_SealInit. Expected _EVP_CIPHER_p.");
        return NULL;
        }
    }
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_unsigned_char_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of EVP_SealInit. Expected _unsigned_char_pp.");
        return NULL;
        }
    }
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of EVP_SealInit. Expected _int_p.");
        return NULL;
        }
    }
{
	_arg4 = PyString_AsString(_obj4);
}
    if (_argc5) {
        if (SWIG_GetPtr(_argc5,(void **) &_arg5,"_EVP_PKEY_pp")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 6 of EVP_SealInit. Expected _EVP_PKEY_pp.");
        return NULL;
        }
    }
    _result = (int )EVP_SealInit(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_EVP_SealUpdate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_CIPHER_CTX * _arg0;
    unsigned char * _arg1;
    int * _arg2;
    unsigned char * _arg3;
    int  _arg4;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOsOi:EVP_SealUpdate",&_argc0,&_obj1,&_argc2,&_obj3,&_arg4)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_SealUpdate. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of EVP_SealUpdate. Expected _int_p.");
        return NULL;
        }
    }
{
	_arg3 = PyString_AsString(_obj3);
}
    EVP_SealUpdate(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_SealFinal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_CIPHER_CTX * _arg0;
    unsigned char * _arg1;
    int * _arg2;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOs:EVP_SealFinal",&_argc0,&_obj1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_SealFinal. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of EVP_SealFinal. Expected _int_p.");
        return NULL;
        }
    }
    EVP_SealFinal(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_CIPHER_CTX_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_CIPHER_CTX * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":EVP_CIPHER_CTX_new")) 
        return NULL;
    _result = (EVP_CIPHER_CTX *)EVP_CIPHER_CTX_new();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_CIPHER_CTX_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_EVP_CIPHER_CTX_free(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_CIPHER_CTX * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_CIPHER_CTX_free",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_CIPHER_CTX_free. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
    EVP_CIPHER_CTX_free(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_python_EVP_SealInit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    EVP_CIPHER_CTX * _arg0;
    EVP_CIPHER * _arg1;
    PyObject * _arg2;
    char * _argc0 = 0;
    char * _argc1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssO:python_EVP_SealInit",&_argc0,&_argc1,&_obj2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of python_EVP_SealInit. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_EVP_CIPHER_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of python_EVP_SealInit. Expected _EVP_CIPHER_p.");
        return NULL;
        }
    }
{
	_arg2 = _obj2;
}
    _result = (PyObject *)python_EVP_SealInit(_arg0,_arg1,_arg2);
{
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_python_EVP_SealUpdate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    EVP_CIPHER_CTX * _arg0;
    PyObject * _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:python_EVP_SealUpdate",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of python_EVP_SealUpdate. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = _obj1;
}
    _result = (PyObject *)python_EVP_SealUpdate(_arg0,_arg1);
{
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_python_EVP_SealFinal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    EVP_CIPHER_CTX * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:python_EVP_SealFinal",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of python_EVP_SealFinal. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
    _result = (PyObject *)python_EVP_SealFinal(_arg0);
{
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_EVP_OpenInit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_CIPHER_CTX * _arg0;
    EVP_CIPHER * _arg1;
    unsigned char * _arg2;
    int  _arg3;
    unsigned char * _arg4;
    EVP_PKEY * _arg5;
    char * _argc0 = 0;
    char * _argc1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj4 = 0;
    char * _argc5 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ssOiOs:EVP_OpenInit",&_argc0,&_argc1,&_obj2,&_arg3,&_obj4,&_argc5)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_OpenInit. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_EVP_CIPHER_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_OpenInit. Expected _EVP_CIPHER_p.");
        return NULL;
        }
    }
{
	_arg2 = PyString_AsString(_obj2);
}
{
	_arg4 = PyString_AsString(_obj4);
}
    if (_argc5) {
        if (SWIG_GetPtr(_argc5,(void **) &_arg5,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 6 of EVP_OpenInit. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_OpenInit(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_EVP_OpenUpdate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_CIPHER_CTX * _arg0;
    unsigned char * _arg1;
    int * _arg2;
    unsigned char * _arg3;
    int  _arg4;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOsOi:EVP_OpenUpdate",&_argc0,&_obj1,&_argc2,&_obj3,&_arg4)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_OpenUpdate. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of EVP_OpenUpdate. Expected _int_p.");
        return NULL;
        }
    }
{
	_arg3 = PyString_AsString(_obj3);
}
    EVP_OpenUpdate(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_OpenFinal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_CIPHER_CTX * _arg0;
    unsigned char * _arg1;
    int * _arg2;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOs:EVP_OpenFinal",&_argc0,&_obj1,&_argc2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_OpenFinal. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    if (_argc2) {
        if (SWIG_GetPtr(_argc2,(void **) &_arg2,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 3 of EVP_OpenFinal. Expected _int_p.");
        return NULL;
        }
    }
    _result = (int )EVP_OpenFinal(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_python_EVP_OpenUpdate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    EVP_CIPHER_CTX * _arg0;
    PyObject * _arg1;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sO:python_EVP_OpenUpdate",&_argc0,&_obj1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of python_EVP_OpenUpdate. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = _obj1;
}
    _result = (PyObject *)python_EVP_OpenUpdate(_arg0,_arg1);
{
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_python_EVP_OpenFinal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    EVP_CIPHER_CTX * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:python_EVP_OpenFinal",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_CIPHER_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of python_EVP_OpenFinal. Expected _EVP_CIPHER_CTX_p.");
        return NULL;
        }
    }
    _result = (PyObject *)python_EVP_OpenFinal(_arg0);
{
	_resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_EVP_VerifyInit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _arg0;
    EVP_MD * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_VerifyInit",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_VerifyInit. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_EVP_MD_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_VerifyInit. Expected _EVP_MD_p.");
        return NULL;
        }
    }
    EVP_VerifyInit(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_VerifyUpdate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _arg0;
    unsigned char * _arg1;
    unsigned int  _arg2;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOi:EVP_VerifyUpdate",&_argc0,&_obj1,&_arg2)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_VerifyUpdate. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    EVP_VerifyUpdate(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_EVP_VerifyFinal(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_MD_CTX * _arg0;
    unsigned char * _arg1;
    unsigned int  _arg2;
    EVP_PKEY * _arg3;
    char * _argc0 = 0;
    PyObject * _obj1 = 0;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"sOis:EVP_VerifyFinal",&_argc0,&_obj1,&_arg2,&_argc3)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_VerifyFinal. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
{
	_arg1 = PyString_AsString(_obj1);
}
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of EVP_VerifyFinal. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_VerifyFinal(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define new_EVP_MD_CTX() ((EVP_MD_CTX *) calloc(1,sizeof(EVP_MD_CTX)))
static PyObject *_wrap_new_EVP_MD_CTX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_EVP_MD_CTX")) 
        return NULL;
    _result = (EVP_MD_CTX *)new_EVP_MD_CTX();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_MD_CTX_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_EVP_MD_CTX(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_EVP_MD_CTX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_MD_CTX * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_EVP_MD_CTX",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_MD_CTX_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_EVP_MD_CTX. Expected _EVP_MD_CTX_p.");
        return NULL;
        }
    }
    delete_EVP_MD_CTX(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define EVP_PKEY_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:EVP_PKEY_type_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_type_set. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_type_get(_swigobj) ((int ) _swigobj->type)
static PyObject *_wrap_EVP_PKEY_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_type_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_type_get. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_type_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_save_type_set(_swigobj,_swigval) (_swigobj->save_type = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_save_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:EVP_PKEY_save_type_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_save_type_set. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_save_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_save_type_get(_swigobj) ((int ) _swigobj->save_type)
static PyObject *_wrap_EVP_PKEY_save_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_save_type_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_save_type_get. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_save_type_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_references_set(_swigobj,_swigval) (_swigobj->references = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_references_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:EVP_PKEY_references_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_references_set. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_references_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_references_get(_swigobj) ((int ) _swigobj->references)
static PyObject *_wrap_EVP_PKEY_references_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_references_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_references_get. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_references_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_save_parameters_set(_swigobj,_swigval) (_swigobj->save_parameters = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_save_parameters_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    int  _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"si:EVP_PKEY_save_parameters_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_save_parameters_set. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_save_parameters_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_save_parameters_get(_swigobj) ((int ) _swigobj->save_parameters)
static PyObject *_wrap_EVP_PKEY_save_parameters_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_save_parameters_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_save_parameters_get. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (int )EVP_PKEY_save_parameters_get(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define EVP_PKEY_attributes_set(_swigobj,_swigval) (_swigobj->attributes = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_attributes_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct stack_st_X509_ATTRIBUTE * _result;
    EVP_PKEY * _arg0;
    struct stack_st_X509_ATTRIBUTE * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_PKEY_attributes_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_attributes_set. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_struct_stack_st_X509_ATTRIBUTE_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_PKEY_attributes_set. Expected _struct_stack_st_X509_ATTRIBUTE_p.");
        return NULL;
        }
    }
    _result = (struct stack_st_X509_ATTRIBUTE *)EVP_PKEY_attributes_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_struct_stack_st_X509_ATTRIBUTE_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define EVP_PKEY_attributes_get(_swigobj) ((struct stack_st_X509_ATTRIBUTE *) _swigobj->attributes)
static PyObject *_wrap_EVP_PKEY_attributes_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct stack_st_X509_ATTRIBUTE * _result;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_attributes_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_attributes_get. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (struct stack_st_X509_ATTRIBUTE *)EVP_PKEY_attributes_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_struct_stack_st_X509_ATTRIBUTE_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define EVP_PKEY_pkey_get(_swigobj) (&_swigobj->pkey)
static PyObject *_wrap_EVP_PKEY_pkey_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_PKEY_pkey * _result;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_pkey_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_get. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    _result = (EVP_PKEY_pkey *)EVP_PKEY_pkey_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_PKEY_pkey_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define new_EVP_PKEY() ((EVP_PKEY *) calloc(1,sizeof(EVP_PKEY)))
static PyObject *_wrap_new_EVP_PKEY(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_PKEY * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_EVP_PKEY")) 
        return NULL;
    _result = (EVP_PKEY *)new_EVP_PKEY();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_PKEY_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_EVP_PKEY(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_EVP_PKEY(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_PKEY * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_EVP_PKEY",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_EVP_PKEY. Expected _EVP_PKEY_p.");
        return NULL;
        }
    }
    delete_EVP_PKEY(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static char * EVP_PKEY_pkey_ptr_set(EVP_PKEY_pkey *obj, char *val) {
    if (obj->ptr) free(obj->ptr);
    obj->ptr = (char *) malloc(strlen(val)+1);
    strcpy(obj->ptr,val);
    return val;
}
static PyObject *_wrap_EVP_PKEY_pkey_ptr_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    EVP_PKEY_pkey * _arg0;
    char * _arg1;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_PKEY_pkey_ptr_set",&_argc0,&_arg1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_ptr_set. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    _result = (char *)EVP_PKEY_pkey_ptr_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define EVP_PKEY_pkey_ptr_get(_swigobj) ((char *) _swigobj->ptr)
static PyObject *_wrap_EVP_PKEY_pkey_ptr_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    EVP_PKEY_pkey * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_pkey_ptr_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_ptr_get. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    _result = (char *)EVP_PKEY_pkey_ptr_get(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

#define EVP_PKEY_pkey_rsa_set(_swigobj,_swigval) (_swigobj->rsa = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_pkey_rsa_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    RSA * _result;
    EVP_PKEY_pkey * _arg0;
    RSA * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_PKEY_pkey_rsa_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_rsa_set. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_RSA_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_PKEY_pkey_rsa_set. Expected _RSA_p.");
        return NULL;
        }
    }
    _result = (RSA *)EVP_PKEY_pkey_rsa_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_RSA_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define EVP_PKEY_pkey_rsa_get(_swigobj) ((RSA *) _swigobj->rsa)
static PyObject *_wrap_EVP_PKEY_pkey_rsa_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    RSA * _result;
    EVP_PKEY_pkey * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_pkey_rsa_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_rsa_get. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    _result = (RSA *)EVP_PKEY_pkey_rsa_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_RSA_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define EVP_PKEY_pkey_dsa_set(_swigobj,_swigval) (_swigobj->dsa = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_pkey_dsa_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct dsa_st * _result;
    EVP_PKEY_pkey * _arg0;
    struct dsa_st * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_PKEY_pkey_dsa_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_dsa_set. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_struct_dsa_st_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_PKEY_pkey_dsa_set. Expected _struct_dsa_st_p.");
        return NULL;
        }
    }
    _result = (struct dsa_st *)EVP_PKEY_pkey_dsa_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_struct_dsa_st_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define EVP_PKEY_pkey_dsa_get(_swigobj) ((struct dsa_st *) _swigobj->dsa)
static PyObject *_wrap_EVP_PKEY_pkey_dsa_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct dsa_st * _result;
    EVP_PKEY_pkey * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_pkey_dsa_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_dsa_get. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    _result = (struct dsa_st *)EVP_PKEY_pkey_dsa_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_struct_dsa_st_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define EVP_PKEY_pkey_dh_set(_swigobj,_swigval) (_swigobj->dh = _swigval,_swigval)
static PyObject *_wrap_EVP_PKEY_pkey_dh_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct dh_st * _result;
    EVP_PKEY_pkey * _arg0;
    struct dh_st * _arg1;
    char * _argc0 = 0;
    char * _argc1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ss:EVP_PKEY_pkey_dh_set",&_argc0,&_argc1)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_dh_set. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,"_struct_dh_st_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of EVP_PKEY_pkey_dh_set. Expected _struct_dh_st_p.");
        return NULL;
        }
    }
    _result = (struct dh_st *)EVP_PKEY_pkey_dh_set(_arg0,_arg1);
    SWIG_MakePtr(_ptemp, (char *) _result,"_struct_dh_st_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define EVP_PKEY_pkey_dh_get(_swigobj) ((struct dh_st *) _swigobj->dh)
static PyObject *_wrap_EVP_PKEY_pkey_dh_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    struct dh_st * _result;
    EVP_PKEY_pkey * _arg0;
    char * _argc0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:EVP_PKEY_pkey_dh_get",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of EVP_PKEY_pkey_dh_get. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    _result = (struct dh_st *)EVP_PKEY_pkey_dh_get(_arg0);
    SWIG_MakePtr(_ptemp, (char *) _result,"_struct_dh_st_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define new_EVP_PKEY_pkey() ((EVP_PKEY_pkey *) calloc(1,sizeof(EVP_PKEY_pkey)))
static PyObject *_wrap_new_EVP_PKEY_pkey(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_PKEY_pkey * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":new_EVP_PKEY_pkey")) 
        return NULL;
    _result = (EVP_PKEY_pkey *)new_EVP_PKEY_pkey();
    SWIG_MakePtr(_ptemp, (char *) _result,"_EVP_PKEY_pkey_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

#define delete_EVP_PKEY_pkey(_swigobj) (free ((char *) _swigobj))
static PyObject *_wrap_delete_EVP_PKEY_pkey(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    EVP_PKEY_pkey * _arg0;
    char * _argc0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:delete_EVP_PKEY_pkey",&_argc0)) 
        return NULL;
    if (_argc0) {
        if (SWIG_GetPtr(_argc0,(void **) &_arg0,"_EVP_PKEY_pkey_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_EVP_PKEY_pkey. Expected _EVP_PKEY_pkey_p.");
        return NULL;
        }
    }
    delete_EVP_PKEY_pkey(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyMethodDef evpcMethods[] = {
	 { "delete_EVP_PKEY_pkey", _wrap_delete_EVP_PKEY_pkey, 1 },
	 { "new_EVP_PKEY_pkey", _wrap_new_EVP_PKEY_pkey, 1 },
	 { "EVP_PKEY_pkey_dh_get", _wrap_EVP_PKEY_pkey_dh_get, 1 },
	 { "EVP_PKEY_pkey_dh_set", _wrap_EVP_PKEY_pkey_dh_set, 1 },
	 { "EVP_PKEY_pkey_dsa_get", _wrap_EVP_PKEY_pkey_dsa_get, 1 },
	 { "EVP_PKEY_pkey_dsa_set", _wrap_EVP_PKEY_pkey_dsa_set, 1 },
	 { "EVP_PKEY_pkey_rsa_get", _wrap_EVP_PKEY_pkey_rsa_get, 1 },
	 { "EVP_PKEY_pkey_rsa_set", _wrap_EVP_PKEY_pkey_rsa_set, 1 },
	 { "EVP_PKEY_pkey_ptr_get", _wrap_EVP_PKEY_pkey_ptr_get, 1 },
	 { "EVP_PKEY_pkey_ptr_set", _wrap_EVP_PKEY_pkey_ptr_set, 1 },
	 { "delete_EVP_PKEY", _wrap_delete_EVP_PKEY, 1 },
	 { "new_EVP_PKEY", _wrap_new_EVP_PKEY, 1 },
	 { "EVP_PKEY_pkey_get", _wrap_EVP_PKEY_pkey_get, 1 },
	 { "EVP_PKEY_attributes_get", _wrap_EVP_PKEY_attributes_get, 1 },
	 { "EVP_PKEY_attributes_set", _wrap_EVP_PKEY_attributes_set, 1 },
	 { "EVP_PKEY_save_parameters_get", _wrap_EVP_PKEY_save_parameters_get, 1 },
	 { "EVP_PKEY_save_parameters_set", _wrap_EVP_PKEY_save_parameters_set, 1 },
	 { "EVP_PKEY_references_get", _wrap_EVP_PKEY_references_get, 1 },
	 { "EVP_PKEY_references_set", _wrap_EVP_PKEY_references_set, 1 },
	 { "EVP_PKEY_save_type_get", _wrap_EVP_PKEY_save_type_get, 1 },
	 { "EVP_PKEY_save_type_set", _wrap_EVP_PKEY_save_type_set, 1 },
	 { "EVP_PKEY_type_get", _wrap_EVP_PKEY_type_get, 1 },
	 { "EVP_PKEY_type_set", _wrap_EVP_PKEY_type_set, 1 },
	 { "delete_EVP_MD_CTX", _wrap_delete_EVP_MD_CTX, 1 },
	 { "new_EVP_MD_CTX", _wrap_new_EVP_MD_CTX, 1 },
	 { "EVP_VerifyFinal", _wrap_EVP_VerifyFinal, 1 },
	 { "EVP_VerifyUpdate", _wrap_EVP_VerifyUpdate, 1 },
	 { "EVP_VerifyInit", _wrap_EVP_VerifyInit, 1 },
	 { "python_EVP_OpenFinal", _wrap_python_EVP_OpenFinal, 1 },
	 { "python_EVP_OpenUpdate", _wrap_python_EVP_OpenUpdate, 1 },
	 { "EVP_OpenFinal", _wrap_EVP_OpenFinal, 1 },
	 { "EVP_OpenUpdate", _wrap_EVP_OpenUpdate, 1 },
	 { "EVP_OpenInit", _wrap_EVP_OpenInit, 1 },
	 { "python_EVP_SealFinal", _wrap_python_EVP_SealFinal, 1 },
	 { "python_EVP_SealUpdate", _wrap_python_EVP_SealUpdate, 1 },
	 { "python_EVP_SealInit", _wrap_python_EVP_SealInit, 1 },
	 { "EVP_CIPHER_CTX_free", _wrap_EVP_CIPHER_CTX_free, 1 },
	 { "EVP_CIPHER_CTX_new", _wrap_EVP_CIPHER_CTX_new, 1 },
	 { "EVP_SealFinal", _wrap_EVP_SealFinal, 1 },
	 { "EVP_SealUpdate", _wrap_EVP_SealUpdate, 1 },
	 { "EVP_SealInit", _wrap_EVP_SealInit, 1 },
	 { "python_EVP_SignFinal", _wrap_python_EVP_SignFinal, 1 },
	 { "EVP_SignFinal", _wrap_EVP_SignFinal, 1 },
	 { "EVP_SignUpdate", _wrap_EVP_SignUpdate, 1 },
	 { "EVP_SignInit", _wrap_EVP_SignInit, 1 },
	 { "EVP_MD_CTX_free", _wrap_EVP_MD_CTX_free, 1 },
	 { "EVP_MD_CTX_new", _wrap_EVP_MD_CTX_new, 1 },
	 { "EVP_des_ede3_cbc", _wrap_EVP_des_ede3_cbc, 1 },
	 { "EVP_md5", _wrap_EVP_md5, 1 },
	 { "EVP_PKEY_free", _wrap_EVP_PKEY_free, 1 },
	 { "EVP_PKEY_new", _wrap_EVP_PKEY_new, 1 },
	 { "EVP_PKEY_assign_RSA", _wrap_EVP_PKEY_assign_RSA, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initevpc)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("evpc", evpcMethods);
	 d = PyModule_GetDict(m);
	 PyDict_SetItemString(d,"EVP_MAX_KEY_LENGTH", PyInt_FromLong((long) EVP_MAX_KEY_LENGTH));
	 PyDict_SetItemString(d,"EVP_MAX_IV_LENGTH", PyInt_FromLong((long) EVP_MAX_IV_LENGTH));
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
