/*
** $Id: opensslc.c,v 1.1 2001/07/12 05:56:48 tlau Exp $
*/

#include <Python.h>
#include <stdio.h>
#include <openssl/err.h>

#include "opensslc.h"

static PyObject* OpenSSLErr;

extern void initerrc(void);
extern void initrandc(void);
extern void initbnc(void);
extern void initrsac(void);
extern void initevpc(void);

void
generate_error(char* message)
{
	unsigned long openssl_error;
	char error_string[1024];

	if (message == NULL)
	{
		message = DEFAULT_ERROR_MESSAGE;
	}

	openssl_error = ERR_get_error();
	ERR_error_string(openssl_error, error_string);
	PyErr_Format(OpenSSLErr, "%s: %s", message, error_string);
}

static PyMethodDef opensslcMethods[] = 
{
	{ NULL, NULL }
};

void
initopensslc()
{
	PyObject *m, *d;
	
	m = Py_InitModule("opensslc", opensslcMethods);
	d = PyModule_GetDict(m);

	OpenSSLErr = PyErr_NewException("opennsl.OpensslErr", NULL, NULL);
	if (OpenSSLErr == NULL)
	{
		fprintf(stderr, "Error creating OpenSSLErr\n");
	}
	initerrc();
	initrandc();
	initbnc();
	initrsac();
	initevpc();
}
