#!/usr/bin/env python
#
# $Id: rsa.py,v 1.1 2001/07/12 05:47:15 tlau Exp $
#

import opensslc
import rsac
import wrap
import bn

class RSA(wrap.Wrapper):
	def __init__(self, ptr = None):
		attr_dict = \
		{
			'flags': (rsac.RSA_flags_get, rsac.RSA_flags_set, None),
			'iqmp': (rsac.RSA_iqmp_get, rsac.RSA_iqmp_set, bn.BIGNUM),
			'dmq1': (rsac.RSA_dmq1_get, rsac.RSA_dmq1_set, bn.BIGNUM),
			'dmp1': (rsac.RSA_dmp1_get, rsac.RSA_dmp1_set, bn.BIGNUM),
			'q': (rsac.RSA_q_get, rsac.RSA_q_set, bn.BIGNUM),
			'p': (rsac.RSA_p_get, rsac.RSA_p_set, bn.BIGNUM),
			'd': (rsac.RSA_d_get, rsac.RSA_d_set, bn.BIGNUM),
			'e': (rsac.RSA_e_get, rsac.RSA_e_set, bn.BIGNUM),
			'n': (rsac.RSA_n_get, rsac.RSA_n_set, bn.BIGNUM),
		}
		wrap.Wrapper.__init__(self, ptr, rsac.RSA_new, rsac.RSA_free, attr_dict)

