#!/usr/bin/env python

from Tkinter import *
import Pmw, tkMessageBox

# Just initialize this with a text widget to search
class SearchDialog(Toplevel):
	def __init__(self, master, text, textname='Unnamed'):
		Toplevel.__init__(self, class_='Fugu_find')
		self.wm_title('Fugu find')
		self.wm_transient(master)
		self.text = text
		self.textname = textname
		self._create_widgets()
		self.lastsearchpos = None
		self.lastsearchstring = None

	def _create_widgets(self):
		frame = Frame(self)
		frame.pack(side=TOP, expand=1, fill=BOTH, padx=10, pady=10)

		l = Label(frame, text='Searching in screen %s' % self.textname)
		l.pack(side=TOP, fill=X)

		self.entry = Pmw.EntryField(frame, labelpos='w', label_text='Find:',
			command=self.find)
		self.entry.pack(side=TOP, expand=1, fill=X, pady=10)
		self.entry.component('entry').focus_set()
		self.entry.component('entry').bind('<Escape>', lambda e, s=self:
			s.destroy())

		f = Frame(frame)
		f.pack(side=TOP, expand=1, fill=BOTH)
		self.case = BooleanVar()
		b1 = Checkbutton(f, text='Ignore case', variable=self.case)
		b1.pack(side=LEFT)
		self.backwards = BooleanVar()
		b2 = Checkbutton(f, text='Find backwards',
			variable=self.backwards)
		b2.pack(side=LEFT)

		self.regex = BooleanVar()
		b3 = Checkbutton(frame, text='Regular expression search',
			variable=self.regex)
		b3.pack(side=TOP, expand=1, fill=X, pady=10)

		g = Frame(frame)
		g.pack(side=TOP, expand=1, fill=BOTH)
		b1 = Button(g, text='Find', command=self.find)
		b1.pack(side=LEFT, expand=1, fill=X, padx=5)
		b2 = Button(g, text='Clear', command=self.clear)
		b2.pack(side=LEFT, expand=1, fill=X, padx=5)
		b3 = Button(g, text='Close', command=self.destroy)
		b3.pack(side=LEFT, expand=1, fill=X, padx=5)

	def find(self, *args):
		searchstring = self.entry.get()
		if not searchstring: return
		if self.lastsearchstring is None or \
			self.lastsearchstring != searchstring:
			self.lastsearchpos = '1.0'
		self.lastsearchstring = searchstring
		if self.case.get():
			nocase = 1
		else:
			nocase = 0
		if self.backwards.get():
			backwards = 1
			startsearch = self.lastsearchpos
		else:
			backwards = 0
			startsearch = self.text.index('%s + 1 chars' %
				self.lastsearchpos)
		if self.regex.get():
			regexp = 1
		else:
			regexp = 0

		searchlen = IntVar()
		start = self.text.search(searchstring, startsearch,
			nocase=nocase, backwards=backwards, count=searchlen,
			regexp=regexp)
		if not start:
			m = tkMessageBox.showerror(
				title='Not found',
				parent=self,
				message='Search string not found.')
			return
		self.lastsearchpos = start
		end = self.text.index('%s + %i chars' % (start, searchlen.get()))
		self.text.tag_remove('sel', '1.0', 'end')
		self.text.tag_add('sel', start,  end)
		self.text.see('sel.first')
	
	def clear(self):
		self.entry.clear()

class App(Frame):
	def __init__(self, master=None):
		Frame.__init__(self, master)
		self.pack()
		self._create_widgets()
	
	def _create_widgets(self):
		self.text = Text(self)
		self.text.insert('end', open('TODO', 'r').read())
		self.text.bind('<Alt-f>', self.search)
		self.text.pack(expand=1, fill=BOTH)
		self.text.focus_set()
	
	def search(self, event):
		t = SearchDialog(self.text)

def main():
	a = App()
	a.mainloop()

if __name__ == '__main__':
	main()
