#!/usr/bin/env python
#
# $Id: FileList.py,v 1.1 2001/07/17 05:52:48 peterh Exp $
#

import os
import re
import types

class RERule:
	def __init__(self, rule):
		self.rule = rule
		self.compiled_rule = re.compile(rule)


	def __call__(self, file_path):
		if self.compiled_rule.search(file_path) is not None:
			return 1
		return 0



class FileList:
	def __init__(self, root_dir = '.', skip_rules = [], exclude_rules = []):
		self.root_dir = root_dir
		self.skip_rules = []
		self.exclude_rules = []
		self.add_rules(self.skip_rules, skip_rules)
		self.add_rules(self.exclude_rules, exclude_rules)
		self.load()


	def add_rules(self, store_list, rule_list):
		for rule in rule_list:
			if type(rule) == types.StringType:
				re_rule = RERule(rule)
				store_list.append(re_rule)
			else:
				store_list.append(rule)

	
	def load(self):
		self.file_list = []
		unlisted_dirs = [self.root_dir]
		while unlisted_dirs:
			current_dirs = unlisted_dirs
			unlisted_dirs = []
			for dir_name in current_dirs:
				if self.check_rules(self.skip_rules, dir_name):
					continue
				prospective_file_list = os.listdir(dir_name)
				for file_name in prospective_file_list:
					if dir_name != '.':
						file_name = os.path.join(dir_name, file_name)
					if os.path.isdir(file_name):
						unlisted_dirs.append(file_name)
					if self.check_rules(self.exclude_rules,
							    file_name):
						continue
					self.file_list.append(file_name)


	def check_rules(self, rules, file_path):
		for rule in rules:
			if rule(file_path):
				return 1
		return 0


	def __str__(self):
		return str(self.file_list)


	def __repr__(self):
		return repr(self.file_list)



if __name__ == '__main__':
	file_list = FileList('.', ['.*CVS'], [os.path.isdir])
	print file_list
