/*
** $Id: FuguExe.c,v 1.2 2001/11/09 19:11:14 peterh Exp $
*/

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <windows.h>

#define MAX_PATH_LEN 4096
#define MAX_VERSION_LEN 256
#define MAX_ERROR_LEN 4096

struct PythonInfo
{
    char   path[MAX_PATH_LEN];
    char   version[MAX_VERSION_LEN];
};

DWORD
read_reg_path(char* path, int max_path_len, char* python_install_path_key_name)
{
    LONG result;
    HKEY python_install_path_key = 0;
    DWORD value_type;

    result = RegOpenKeyEx(HKEY_LOCAL_MACHINE, python_install_path_key_name, 0, KEY_READ, &python_install_path_key);
    if (result == ERROR_SUCCESS)
    {
	result = RegQueryValueEx(python_install_path_key, "", NULL, &value_type, (LPBYTE) path, &max_path_len);
	if (result == ERROR_SUCCESS)
	{
	    return ERROR_SUCCESS;
	}
    }

    return result;
}

DWORD
get_python_info(struct PythonInfo* python_info)
{
    DWORD result;

    result = read_reg_path(python_info->path, MAX_PATH_LEN, "SOFTWARE\\Python\\PythonCore\\2.1\\InstallPath");
    if (result == ERROR_SUCCESS)
    {
	strcpy(python_info->version, "2.1");
	return ERROR_SUCCESS;
    }
    if (result != ERROR_FILE_NOT_FOUND)
    {
	return result;
    }
    
    result = read_reg_path(python_info->path, MAX_PATH_LEN, "SOFTWARE\\Python\\PythonCore\\2.0\\InstallPath");
    if (result == ERROR_SUCCESS)
    {
	strcpy(python_info->version, "2.0");
	return ERROR_SUCCESS;
    }
    if (result != ERROR_FILE_NOT_FOUND)
    {
	return result;
    }

    result = read_reg_path(python_info->path, MAX_PATH_LEN, "SOFTWARE\\Python\\PythonCore\\1.6\\InstallPath");
    if (result == ERROR_SUCCESS)
    {
	strcpy(python_info->version, "1.6");
	return ERROR_SUCCESS;
    }
    if (result != ERROR_FILE_NOT_FOUND)
    {
	return result;
    }

    result = read_reg_path(python_info->path, MAX_PATH_LEN, "SOFTWARE\\Python\\PythonCore\\1.5\\InstallPath");
    if (result == ERROR_SUCCESS)
    {
	strcpy(python_info->version, "1.5");
	return ERROR_SUCCESS;
    }

    return result;
}


int PASCAL
WinMain(HINSTANCE instance, HINSTANCE prev_instance, LPSTR cmd_params, int cmd_show)
{
    struct PythonInfo	python_info;
    DWORD result;
    char win_error_msg[MAX_ERROR_LEN];
    char error_msg[MAX_ERROR_LEN];
    char* fugu_path;
    char pythonw_path[MAX_PATH_LEN];
    char command_line[MAX_PATH_LEN];
    char current_directory[MAX_PATH_LEN];
    char program_command_line[MAX_PATH_LEN];
    BOOL bool_result;
    STARTUPINFO startup_info;
    PROCESS_INFORMATION process_info;
    char* backslash_pos;
    char* current_pos;
    int inside_quotes;

    result = GetCurrentDirectory(MAX_PATH_LEN, current_directory);
    if (result == 0)
    {
	result = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, result, 0, win_error_msg, MAX_ERROR_LEN, NULL);
	if (result == 0)
	{
	    MessageBox(NULL, "FormatMessage failed", "Error", MB_OK);
	}
	else
	{
	    _snprintf(error_msg, MAX_ERROR_LEN, "Error retreiving current directory name: %s", win_error_msg);
	    MessageBox(NULL, error_msg, "Error", MB_OK);
	}

	return -1;
    }

    strcpy(program_command_line, GetCommandLine());
    inside_quotes = 0;
    for(current_pos = program_command_line; *current_pos != 0; ++current_pos)
    {
	if (!inside_quotes)
	{
	    if (*current_pos == ' ')
	    {
		break;
	    }
	    if (*current_pos == '"')
	    {
		inside_quotes = 1;
	    }
	}
	else
	{
	    if (*current_pos == '"')
	    {
		inside_quotes = 0;
	    }
	}
    }
    if (current_pos != NULL)
    {
	*current_pos = 0;
    }
 
    backslash_pos = strrchr(program_command_line, '\\');
    if (backslash_pos != NULL)
    {
	*backslash_pos = 0;
    }
    if (program_command_line[0] == '"')
    {
	fugu_path = program_command_line + 1;
    }
    else
    {
	fugu_path = program_command_line;
    }

    result = SetCurrentDirectory(fugu_path);
    if (result == 0)
    {
	result = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, result, 0, win_error_msg, MAX_ERROR_LEN, NULL);
	if (result == 0)
	{
	    MessageBox(NULL, "FormatMessage failed", "Error", MB_OK);
	}
	else
	{
	    _snprintf(error_msg, MAX_ERROR_LEN, "Error retreiving current directory name: %s", win_error_msg);
	    MessageBox(NULL, error_msg, "Error", MB_OK);
	}

	return -1;
    } 

    result = GetCurrentDirectory(MAX_PATH_LEN, current_directory);
    if (result == 0)
    {
	result = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, result, 0, win_error_msg, MAX_ERROR_LEN, NULL);
	if (result == 0)
	{
	    MessageBox(NULL, "FormatMessage failed", "Error", MB_OK);
	}
	else
	{
	    _snprintf(error_msg, MAX_ERROR_LEN, "Error retreiving current directory name: %s", win_error_msg);
	    MessageBox(NULL, error_msg, "Error", MB_OK);
	}

	return -1;
    }

    result = get_python_info(&python_info);
    if (result != ERROR_SUCCESS)
    {
	result = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, result, 0, win_error_msg, MAX_ERROR_LEN, NULL);
	if (result == 0)
	{
	    MessageBox(NULL, "FormatMessage failed", "Error", MB_OK);
	}
	else
	{
	    _snprintf(error_msg, MAX_ERROR_LEN, "Error loading Python registry key: %s", win_error_msg);
	    MessageBox(NULL, error_msg, "Error", MB_OK);
	}

	return -1;
    }

    _snprintf(pythonw_path, MAX_PATH_LEN, "%s\\pythonw.exe", python_info.path);
    _snprintf(command_line, MAX_PATH_LEN, "\"%s\\pythonw.exe\" fugu.py", python_info.path);
    memset(&startup_info, 0, sizeof(STARTUPINFO));
    bool_result = CreateProcess(pythonw_path, command_line, NULL, NULL, FALSE, 0, NULL, current_directory, &startup_info, &process_info);

    return 0;
}
