# 
# $Id: build_installer.py,v 1.1 2001/07/17 05:52:48 peterh Exp $
#

import compileall
import FileList
import os
import shutil
import string
import win_configure
import winstall

prefix = '..' 
skip_dirs = \
[
	'.*\\\\py-openssl.*',
	'.*\\\\rsaref.*',
	'.*\\\\win.*',
	'.*\\\\CVS',
]
excludes = \
[
	os.path.isdir,
]


def add_with_python(installer):
	installer.add('CustomAction', 'InstallPython2.1', 2, 'Python-2.1-Installer', 'Python-2.1.exe')
	installer.add('CustomAction', 'InstallPythonWin', 2, 'PythonWinInstaller', 'win32all-140.exe')
	installer.add('InstallExecuteSequence', 'InstallPython2.1', 'Not Installed AND PythonPath = "  "', 650)
	installer.add('InstallExecuteSequence', 'InstallPythonWin', 'Not Installed AND PYTHONWIN_BUILD = 0', 651)
	installer.add('LaunchCondition', 'Privileged', 'You must have Administrator privileges to run this Fugu installer.')
	installer.add('Binary', 'Python-2.1-Installer', 'C:\\incoming\\Python-2.1.exe')
	installer.add('Binary', 'PythonWinInstaller', 'C:\\incoming\\win32all-140.exe')
	installer.add_file(os.path.join(prefix, 'win\\opensslc-2_1.pyd'), 
			   'openssl/opensslc.pyd')



def add_wo_python(installer):
	installer.add('LaunchCondition', 'Installed OR PYTHONWIN_BUILD > 0', 'This Fugu Installer requires that PythonWin (a.k.a. win32all) already be installed on this system.')
	installer.add('LaunchCondition', 'Installed OR PythonPath <> "  "', 'This Fugu Installer requires that Python 2.0 or 2.1 already be installed on this system.')
	installer.add_file(os.path.join(prefix, 'win\\opensslc-2_0.pyd'), 
			   'openssl/opensslc.pyd', 'PYTHON_VERSION_2_0 <> " "')
	installer.add_file(os.path.join(prefix, 'win\\opensslc-2_1.pyd'), 
			   'openssl/opensslc.pyd', 'PYTHON_VERSION_2_1 <> " "')


def add_common(installer):
	version_file_name = os.path.join(prefix, '.version')
	version = string.strip(open(version_file_name, 'r').readline())
	file_list = FileList.FileList(prefix, skip_dirs, excludes)
	for file_path in file_list.file_list:
		installer.add_file(file_path, file_path[len(prefix)+1:])
	installer.add_file(os.path.join(prefix, 
					'win\\FuguExe\\Release\\Fugu.exe'), 
			   'Fugu.exe')
	installer.add_file(os.path.join(prefix, 'win\\opensslc-2_0.pyd'), 
			   'openssl/opensslc-2_0.pyd')
	installer.add_file(os.path.join(prefix, 'win\\opensslc-2_1.pyd'), 
			   'openssl/opensslc-2_1.pyd')
	installer.add_property('ProductName', 'Fugu')
	installer.add_property('ProductVersion', version)
	installer.add_property('PYTHON_VERSION_2_0', ' ')
	installer.add_property('PYTHON_VERSION_2_1', ' ')
	installer.add_property('PYTHONWIN_BUILD', '0')
	installer.add_property('APPS_TEST', '1')
	installer.add_custom_action('SetPythonPath', 51, 'PythonPath', '{[PYTHON_VERSION_2_0][PYTHON_VERSION_2_1]}')
	installer.add('InstallExecuteSequence', 'SetPythonPath', '', 60)
	installer.add('InstallUISequence', 'SetPythonPath', '', 60)
	installer.add('RegLocator', 'PythonVersion2.0', 2, 'SOFTWARE\\Python\\PythonCore\\2.0\\InstallPath', None, 2)
	installer.add('RegLocator', 'PythonVersion2.1', 2, 'SOFTWARE\\Python\\PythonCore\\2.1\\InstallPath', None, 2)
	installer.add('RegLocator', 'PythonWinBuild', 2, 'SOFTWARE\\Python\\Pythonwin\\Build', None, 2)
	installer.add('AppSearch', 'PYTHON_VERSION_2_0', 'PythonVersion2.0')
	installer.add('AppSearch', 'PYTHON_VERSION_2_1', 'PythonVersion2.1')
	installer.add('AppSearch', 'PYTHONWIN_BUILD', 'PythonWinBuild')
	installer.update("update InstallUISequence set Sequence = 50 where Action = 'AppSearch'")
	installer.set_default_install_path('[ProgramFilesFolder]Fugu-%s' % (version))
	installer.add('Icon', 'fugu-icon.exe', os.path.join(prefix, 'win\\fugu-icon.exe'))
	installer.add_shortcut('StartMenuFolder\\Programs\\Gale', 'Fugu.exe', 'Fugu', 'fugu-icon.exe')


orig_dir = os.getcwd()
os.chdir(os.path.join(prefix, 'py-openssl'))
os.system('python setup.py build --build-lib ..')
os.chdir(orig_dir)
shutil.copy('\\peterh\\ext\\openssl-0.9.6a\\out32dll\\libeay32.dll', os.path.join(prefix, 'openssl'))
os.unlink(os.path.join(prefix, 'openssl', 'opensslc.pyd'))
compileall.compile_dir(prefix)
win_configure.run(prefix)
installer_wo_python = winstall.Installer('Fugu-woPython')
add_common(installer_wo_python)
add_wo_python(installer_wo_python)
installer_wo_python.build()
installer_with_python = winstall.Installer('Fugu-withPython')
add_common(installer_with_python)
add_with_python(installer_with_python)
installer_with_python.build()
