import os
import string

SubstituteErr = 'SubstituteErr'

def substitute(vars, line):
    in_name = 0
    name = ''
    new_line = ''
    i = 0
    while i < len(line):
        if in_name:
                if line[i] == '@':
                    if i == len(line) - 1 or line[i + 1] != '@':
                        new_line = new_line + vars[name]
                        in_name = 0
                        name = ''
                    else:
                        name = name + '@'
                        i = i + 1
                        if i == len(line) - 1:
                            raise SubstituteErr, 'Unbalanced @'
                else:
                    name = name + line[i]
        else:
            if line[i] == '@':
                if i == len(line) - 1:
                    raise SubstituteErr, 'Unbalanced @'
                if line[i + 1] == '@':
                    i = i + 1
                    new_line = new_line + line[i]
                else:
                    in_name = 1
            else:
                new_line = new_line + line[i]
        i = i + 1
    return new_line


def run(dir_name):
	version_file = open(os.path.join(dir_name, '.version'), 'r')
	version = version_file.readline()
	version = string.strip(version)

	vars = \
	{
	    'FUGUVERSION': version,
	    'PYTHON': 'python',
	    'prefix': '',
	    'exec_prefix': ''
	}

	file_names = \
	[
	    'fugu.py',
	    'fugu-config.py',
	    'pygale\\version.py',
	]
	for file_name in file_names:
	    file_name = os.path.join(dir_name, file_name)
	    fugu_in = open('%s.in' % (file_name), 'r')
	    fugu_out = open('%s' % (file_name), 'w')

	    for line in fugu_in.readlines():
		line = substitute(vars, line)
		fugu_out.write(line)
	    fugu_in.close()
	    fugu_out.close()
