#
# $Id: winstall.py,v 1.1 2001/07/17 05:52:49 peterh Exp $
#

import pythoncom
import os
import shutil
import stat
import string
import tempfile
import traceback
import types
import win32api
import win32com.client
import win32com.client.gencache

wininst = win32com.client.gencache.GetModuleForProgID("WindowsInstaller.Installer")
msi = win32com.client.constants

msidbFileAttributesVital = 512

template_installer_name = 'EmptyInstaller.msi'
project_installer_name = 'test.msi'


class WinstallErr(Exception):
	pass


class CabFile:
	def __init__(self, file_name):
		self.bin = 'C:\\programs\\devel\\mssdk\\bin\\cabarc.exe'
		self.file_name = file_name
		self.files = []


	def add_file(self, file):
		self.files.append(file)


	def clean(self):
		os.unlink(self.file_name)


	def create(self):
		temp_file_name = tempfile.mktemp()
		temp_file = open(temp_file_name, 'w')
		for file in self.files:
			temp_file.write('%(real_path)s %(id)s\n' % file)
		temp_file.close()
		command = '%s N %s @%s' % (self.bin, self.file_name, 
					   temp_file_name)
		result = os.system(command)
		os.unlink(temp_file_name)



class MSIIdentifier:
	set_func = 'SetStringData'


class MSICondition:
	set_func = 'SetStringData'


class MSIInteger:
	set_func = 'SetIntegerData'


class MSIFormatted:
	set_func = 'SetStringData'


class MSIRegPath:
	set_func = 'SetStringData'


class MSIBinary:
	set_func = 'SetStream'


class MSIText:
	set_func = 'SetStringData'


class MSIFilename:
	set_func = 'SetStringData'


class MSIShortcut:
	set_func = 'SetStringData'


class MSICustomSource:
	set_func = 'SetStringData'



class Database:
	table_data = \
	{
		'AppSearch': \
			(
				('Property', MSIIdentifier, 1),
				('Signature_', MSIIdentifier, 1),
			),
		'Binary': \
			(
				('Name', MSIIdentifier, 1),
				('Data', MSIBinary, 0),
			),
		'CustomAction': \
			(
				('Action', MSIIdentifier, 1),
				('Type', MSIInteger, 0),
				('Source', MSICustomSource, 0),
				('Target', MSIFormatted, 0),
			),
		'Icon': \
			(
				('Name', MSIIdentifier, 1),
				('Data', MSIBinary, 0),
			),
		'InstallExecuteSequence': \
			(
				('Action', MSIIdentifier, 1),
				('Condition', MSICondition, 0),
				('Sequence', MSIInteger, 0),
			),
		'InstallUISequence': \
			(
				('Action', MSIIdentifier, 1),
				('Condition', MSICondition, 0),
				('Sequence', MSIInteger, 0),
			),
		'LaunchCondition': \
			(
				('Condition', MSICondition, 1),
				('Description', MSIFormatted, 0),
			),
		'RegLocator': \
			(
				('Signature_', MSIIdentifier, 1),
				('Root', MSIInteger, 0),
				('`Key`', MSIRegPath, 0),
				('Name', MSIFormatted, 0),
				('Type', MSIInteger),
			),
		'Shortcut': \
			(
				('Shortcut', MSIIdentifier, 1),
				('Directory_', MSIIdentifier, 0),
				('Name', MSIFilename, 0),
				('Component_', MSIIdentifier, 0),
				('Target', MSIShortcut, 0),
				('Arguments', MSIFormatted, 0),
				('Description', MSIText, 0),
				('Hotkey', MSIInteger, 0),
				('Icon_', MSIIdentifier, 0),
				('IconIndex', MSIInteger, 0),
				('ShowCmd', MSIInteger, 0),
				('WkDir', MSIIdentifier, 0),
			),
		'_Streams': \
			(
				('Name', MSIText, 1),
				('Data', MSIBinary, 0),
			),
	}

	def __init__(self, file_name):
		self.installer = win32com.client.Dispatch("WindowsInstaller.Installer")
		self.db = self.installer.OpenDatabase(file_name, 
						msi.msiOpenDatabaseModeTransact)
		self.file_sequence = 0


	def run_query(self, query_str):
		try:
			view = self.db.OpenView(query_str)
			view.Execute()
			result = view.Fetch()
			if result is None:
				return None
			return wininst.Record(result)
		except pythoncom.ole_error, e:
			error = self.installer.LastErrorRecord
			error = wininst.Record(error)
			self.throw_msi_error(error)


	def run_statement(self, query_str):
		try:
			view = self.db.OpenView(query_str)
			view.Execute()
		except pythoncom.ole_error, e:
			error = self.installer.LastErrorRecord
			error = wininst.Record(error)
			self.throw_msi_error(error)


	def throw_msi_error(self, error_record):
		err_num = error_record.StringData(1)
		file_name = error_record.StringData(2)
		error_info = error_record.StringData(3)
		error_info = error_info + ': ' + error_record.StringData(4)
		raise WinstallErr, "%s in file '%s' %s" % \
				   (err_num, file_name, error_info)


	def commit(self):
		self.db.Commit()


	def insert_dir(self, dir_obj):
		if dir_obj.id == 'TARGETDIR' or \
		   dir_obj.id == 'DesktopFolder' or \
		   dir_obj.id == 'StartMenuFolder':
			return
		insert_statement = "insert into Directory (Directory, Directory_Parent, DefaultDir) values ('%(id)s', '%(parent_id)s', '%(short_name)s|%(name)s')" % dir_obj
		self.run_statement(insert_statement)


	def insert_file(self, file):
		self.file_sequence = self.file_sequence + 10
		file.sequence = self.file_sequence
		insert_statement = "insert into Component (Component, ComponentId, Directory_, Attributes, Condition, KeyPath) values ('%(component_id)s', '%(guid)s', '%(dir_id)s', %(component_attr)d, '%(cond)s', '%(id)s')" % file
		self.run_statement(insert_statement)
		insert_statement = "insert into File (File, Component_, FileName, FileSize, Version, Language, Attributes, Sequence) values ('%(id)s', '%(component_id)s', '%(short_name)s|%(file_name)s', '%(file_size)s', '%(version)s', '%(language)s', %(attr)d, %(sequence)d)" % file
		self.run_statement(insert_statement)
		insert_statement = "insert into FeatureComponents (Feature_, Component_) values ('_MainFeature', '%(component_id)s')" % file
		self.run_statement(insert_statement)


	def insert_cab(self, cab_file):
		delete_statement = "delete from _Streams where Name = 'Instal01.cab'"
		self.run_statement(delete_statement)
		table_structure = self.table_data['_Streams']
		insert_data = ['Instal01.cab', cab_file.file_name]
		self.insert(('_Streams', insert_data))


	def add_property(self, name, value):
		query_str = "select * from Property where Property = '%s'" % (name)
		record = self.run_query(query_str)
		if record is None:
			self.insert_property(name, value)
		else:
			self.update_property(name, value)


	def insert_property(self, name, value):
		insert_statement = "insert into Property (Property, Value) values ('%s', '%s')" % (name, value)
		self.run_statement(insert_statement)


	def update_property(self, name, value):
		update_statement = "update Property set Value = '%s' where Property = '%s'" % (value, name)
		self.run_statement(update_statement)


	def update_custom_action(self, action, type, source, target):
		update_statement = "update CustomAction set Target = '%s' where Action = '%s'" % (target, action)
		self.run_statement(update_statement)


	def add_custom_action(self, action_data):
		insert_statement = "insert into CustomAction (Action, Type, Source, Target) values ('%s', %d, '%s', '%s')" % action_data
		self.run_statement(insert_statement)


	def insert(self, insert_info):
		table_name, insert_data = insert_info
		table_structure = self.table_data[table_name]
		view_query = 'select * from %s' % (table_name)
		view = self.db.OpenView(view_query)
		record = self.installer.CreateRecord(len(table_structure))
		record = wininst.Record(record)
		for i in range(0, len(table_structure)):
			if insert_data[i] is None:
				continue
			set_func_name = table_structure[i][1].set_func
			set_func = getattr(record, set_func_name)
			set_func(i + 1, insert_data[i])
		try:
			view.Modify(msi.msiViewModifyInsert, record)
		except pythoncom.ole_error, e:
			error = self.installer.LastErrorRecord
			error = wininst.Record(error)
			self.throw_msi_error(error)



def get_key_id():
	id = str(pythoncom.CreateGuid())[1:-1]
	id = '_' + string.join(string.split(id, '-'), '')
	return id



class InstallerData:
	def __init__(self, installer):
		self.installer = installer
		self.dirs = {}
		self.files = {}
		self.properties = {}
		self.custom_actions = {}


	def add_property(self, name, value):
		self.properties[name] = value


	def get_file(self, file_name):
		return self.files[file_name]


	def add_file(self, file):
		if self.files.has_key(file.install_path):
			current_file = self.files[file.install_path]
			if type(current_file) == types.ListType:
				current_file.append(file)
				return
			else:
				self.files[file.install_path] = [current_file, file]
				return
		self.files[file.install_path] = file


	def get_dir(self, dir_name):
		return self.dirs[dir_name]


	def get_and_add_nonexistant_dir(self, dir_name):
		sub_dirs = []
		while not self.dirs.has_key(dir_name):
			dir_name, sub_dir = os.path.split(dir_name)
			sub_dirs.insert(0, sub_dir)
		temp_dir_name = tempfile.mktemp()
		base_temp_dir_name = temp_dir_name
		os.mkdir(temp_dir_name)
		for sub_dir in sub_dirs:
			temp_dir_name = os.path.join(temp_dir_name, sub_dir)
			os.mkdir(temp_dir_name)
			dir_name = os.path.join(dir_name, sub_dir)
			new_dir = Directory(self.installer, temp_dir_name, 
					    dir_name)
			self.add_dir(new_dir)
		while temp_dir_name != base_temp_dir_name:
			os.rmdir(temp_dir_name)
			temp_dir_name = os.path.dirname(temp_dir_name)
		os.rmdir(temp_dir_name)
		return self.dirs[dir_name]


	def get_and_add_dir(self, dir_name, real_path = None):
		if real_path is None:
			return self.get_and_add_nonexistant_dir(dir_name)
		sub_dirs = []
		real_sub_dirs = []
		while not self.dirs.has_key(dir_name):
			dir_name, sub_dir = os.path.split(dir_name)
			sub_dirs.insert(0, sub_dir)
			real_path, real_sub_dir = os.path.split(real_path)
			real_sub_dirs.insert(0, real_sub_dir)
		index = 0
		for sub_dir in sub_dirs:
			dir_name = os.path.join(dir_name, sub_dir)
			real_path = os.path.join(real_path, 
						 real_sub_dirs[index])
			new_dir = Directory(self.installer, real_path, dir_name)
			self.add_dir(new_dir)
			index = index + 1
		return self.dirs[dir_name]


	def add_dir(self, dir):
		self.dirs[dir.path] = dir



class Directory:
	def __init__(self, installer, real_path, install_path, id = None,
		     parent = None):
		self.installer = installer
		if id is None:
			self.id = get_key_id()
			self.name = os.path.basename(install_path)
			self.short_name = win32api.GetShortPathName(real_path)
			self.short_name = os.path.basename(self.short_name)
			self.path = install_path
			self.parent = self.set_parent(install_path)
		else:
			self.id = id
			self.name = ''
			self.path = install_path
			if parent is not None:
				self.parent = self.installer.data.get_dir(parent)

	
	def set_parent(self, dir_path):
		parent_name = os.path.dirname(dir_path)
		return self.installer.data.get_dir(parent_name)


	def __getitem__(self, name):
		if name == 'parent_id':
			return self.parent.id
		return self.__dict__[name]



class File:
	def __init__(self, installer, real_path, install_path = None, 
		     condition = ''):
		self.installer = installer
		if install_path is None:
			install_path = real_path
		self.id = get_key_id()
		self.component_id = get_key_id()
		self.guid = pythoncom.CreateGuid()
		dir_path = os.path.dirname(install_path)
		data = self.installer.data
		real_dir_path = os.path.dirname(real_path)
		self.dir = data.get_and_add_dir(dir_path, real_dir_path)
		self.install_path = install_path
		self.file_name = os.path.basename(install_path)
		self.short_name = win32api.GetShortPathName(real_path)
		self.short_name = os.path.basename(self.short_name)
		self.file_size = os.stat(real_path)[stat.ST_SIZE]
		self.real_path = real_path
		self.version = ''
		self.cond = condition
		self.attr = msidbFileAttributesVital
		self.component_attr = 0
		self.sequence = 1
		self.language = ''


	def get_dir(self, file_path):
		dir_name = os.path.dirname(file_path)
		return self.installer_info.get_dir(dir_name)


	def __getitem__(self, name):
		if name == 'dir_id':
			return self.dir.id
		return self.__dict__[name]




class Installer:
	def __init__(self, project_name):
		self.project_name = project_name
		self.data = InstallerData(self)
		self.default_install_path = project_name
		self.inserts = []
		self.updates = []
		self.icons = []
		root_dir = Directory(self, None, '', 'TARGETDIR')
		self.data.add_dir(root_dir)
		desktop_dir = Directory(self, None, 'DesktopFolder', 
					'DesktopFolder', '')
		self.data.add_dir(desktop_dir)
		start_menu_dir = Directory(self, None, 'StartMenuFolder', 
					   'StartMenuFolder', '')
		self.data.add_dir(start_menu_dir)


	
	def build(self):
		shutil.copy(template_installer_name, self.project_name + '.msi')
		self.db = Database(self.project_name + '.msi')
		for dir_obj in self.data.dirs.values():
			self.db.insert_dir(dir_obj)
		for insert_info in self.inserts:
			self.db.insert(insert_info)
		for property in self.data.properties.items():
			self.db.add_property(property[0], property[1])
		for custom_action in self.data.custom_actions.items():
			self.db.add_custom_action(custom_action[1])
		self.db.update_custom_action('DIR_CA_TARGETDIR', 51, 
					     'TARGETDIR', 
					     self.default_install_path)
		for update_statement in self.updates:
			self.db.run_statement(update_statement)
		self.commit()
		cab_file = CabFile(tempfile.mktemp())
		for file in self.data.files.values():
			if type(file) == types.ListType:
				for file_obj in file:
					self.db.insert_file(file_obj)
					cab_file.add_file(file_obj)
			else:
				self.db.insert_file(file)
				cab_file.add_file(file)
		cab_file.create()
		self.db.insert_cab(cab_file)
		cab_file.clean()
		self.commit()



	def commit(self):
		try:
			self.db.commit()
		except pythoncom.ole_error, e:
			error = db.installer.LastErrorRecord
			error = wininst.Record(error)
			self.db.throw_msi_error(error)


	def add_file(self, real_path, install_path, condition = ''):
		file = File(self, real_path, install_path, condition)
		self.data.add_file(file)


	def add_property(self, name, value):
		self.data.add_property(name, value)


	def set_default_install_path(self, path):
		self.default_install_path = path


	def add_custom_action(self, action, type, source, target):
		self.data.custom_actions[action] = (action, type, source, target)

	def add(self, table_name, *args):
		self.inserts.append((table_name, args))


	def update(self, statement):
		self.updates.append(statement)


	def add_icon(self, name, file_name):
		self.icons.append((name, file_name))


	def add_shortcut(self, directory, component_file_name, name, icon_name):
		dir = self.data.get_and_add_nonexistant_dir(directory)
		file = self.data.get_file(component_file_name)
		self.add('Shortcut', get_key_id(), dir.id, name, 
			 file.component_id, '_MainFeature', None, None, None, 
			 icon_name, 0, 1, None)


