/*
 * $Id: filemanager.cpp,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "filemanager.h"

#include <fcntl.h>

FileManager FileManager::m_cInstance;

static guint HashFunc(gconstpointer pKey)
{
    guint nKey = (guint)pKey;
    guint result = ((nKey >> 24) & 0x00ff) +
                   ((nKey >> 16) & 0x00ff) +
                   ((nKey >> 8) & 0x00ff) +
                   (nKey & 0x00ff);

    return result;
}

static gboolean EqualFunc(gconstpointer pKey1,
                          gconstpointer pKey2)
{
    return (pKey1 == pKey2 ? TRUE : FALSE);
}

static void KeyDestroy(gpointer data)
{
    // no operation
}

static void ValueDestroy(gpointer data)
{
    if (data) {
        g_free(data);
    }
}

typedef struct _SEARCH_DATA {
    guint result;
    const gchar* pFileName;
} SEARCH_DATA, *LP_SEARCH_DATA;

static void searchFunc(gpointer key,
                       gpointer value,
                       gpointer data)
{
    LP_SEARCH_DATA lpData = (LP_SEARCH_DATA)data;
    
    if (strcmp(lpData->pFileName, (const gchar*)value) == 0) {
        lpData->result = (guint)key;
    }
}

/**
 * 󥹥ȥ饯
 */
FileManager::FileManager()
{
    m_nMaxFileNumber = 0;
    m_pFileTable = g_hash_table_new_full
        (HashFunc, EqualFunc, KeyDestroy, ValueDestroy);
    
    if (!m_pFileTable) {
        throw "Out of Memory Error.";
    }
}

/**
 * ǥȥ饯
 */
FileManager::~FileManager()
{
    g_hash_table_destroy(m_pFileTable);
}

/**
 * ե̾б륤ǥåͤޤ
 * 
 * @param pFileName ե̾
 * @return ǥå (>0)
 */
guint FileManager::getIndex(const gchar* pFileName)
{
    guint result = 0;
    SEARCH_DATA searchdata = { 0, pFileName };
    
    g_hash_table_foreach(m_pFileTable, searchFunc, &searchdata);
    
    result = searchdata.result;
    
    if (0 >= result) {
        gchar* pCopy = g_strdup(pFileName);
        
        if (!pCopy) {
            throw "Out of Memory Error!";
        }
        
        g_hash_table_insert(m_pFileTable,
                            (gpointer)++m_nMaxFileNumber,
                            pCopy);
        
        result = m_nMaxFileNumber;
    }
    
    return result;
}

/**
 * ǥåͤбե̾ޤ
 * 
 * @param nIndex ǥå
 * @return ե̾
 */
const gchar* FileManager::getFileName(guint nIndex)
{
    return (const gchar*)g_hash_table_lookup
        (m_pFileTable, (gconstpointer)nIndex);
}

/**
 * ͣΥ󥹥󥹥֥Ȥޤ
 */
FileManager& FileManager::getInstance()
{
    return m_cInstance;
}

/**
 * 䵻եۤե̾ޤ
 * 
 * @return ե̾פˤʤäߥ󥰤 free() 
 *         ɬפޤ
 */
char* FileManager::createFile()
{
    char* pFileName = createNewFusenshiFileName();
    
    if (pFileName) {
        const int flags = O_WRONLY | O_CREAT | O_TRUNC | O_EXCL;
        const mode_t mode = S_IRUSR | S_IWUSR;
        
        int fd = open(pFileName, flags, mode);
        
        if (0 <= fd) {
            close(fd);
        }
        else {
            fprintf(stderr, "%s: Can't create new file. (%s)\n",
                APP_NAME, pFileName);
            
            free(pFileName);
            pFileName = NULL;
        }
    }
    
    return pFileName;
}

/**
 * ǥåбեޤ
 * 
 * @param nIndex ǥå
 */
void FileManager::removeFile(guint nIndex)
{
    const gchar* pFileName = getFileName(nIndex);
    
    if (pFileName) {
        remove(pFileName);
        g_hash_table_remove(m_pFileTable, (gconstpointer)nIndex);
    }
    else {
        fprintf(stderr, "%s: Unknown file ID. (%d)\n", 
            APP_NAME, nIndex);
    }
}
