/*
 * $Id: filemanager.h,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___FILEMANAGER_H
#define ___FILEMANAGER_H

#include "glib.h"

class FileManager {
public:
    /**
     * ǥȥ饯
     */
    ~FileManager();
    
    /**
     * ե̾б륤ǥåͤޤ
     * 
     * @param pFileName ե̾
     * @return ǥå
     */
    guint getIndex(const gchar* pFileName);
    
    /**
     * ǥåͤбե̾ޤ
     * 
     * @param nIndex ǥå
     * @return ե̾
     */
    const gchar* getFileName(guint nIndex);
    
    /**
     * 䵻եۤե̾ޤ
     * 
     * @return ե̾פˤʤäߥ󥰤 free() 
     *         ɬפޤ
     */
    char* createFile();
    
    /**
     * ǥåбեޤ
     * 
     * @param nIndex ǥå
     */
    void removeFile(guint nIndex);
    
private:
    /**
     * 󥹥ȥ饯
     */
    FileManager();
    
public:
    /**
     * ͣΥ󥹥󥹥֥Ȥޤ
     */
    static FileManager& getInstance();
    
private:
    /**
     * ե̾Υơ֥
     */
    GHashTable* m_pFileTable;
    
    /**
     * ե̾ơ֥οֹ
     */
    guint m_nMaxFileNumber;
    
private:
    /**
     * ͣΥ󥹥󥹥֥
     */
    static FileManager m_cInstance;
};

#endif
