/*
 * $Id: fio.cpp,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"

#include "fioservice.h"

#include <fts.h>
#include <signal.h>

static void sigTerm(int num);
static void sigPipe(int num);

static gpointer doServiceThread(gpointer data);

/**
 * եI/Oץ򳫻Ϥޤ
 * 
 * @param inFD ɥץȤΥѥ
 * @param outFD ɥץȤΥѥ
 */
void fioServiceStart(int inFD, int outFD)
{
    char *pDirPath = (char*)getAppDir(APP_NAME);
    char *paths[] = {pDirPath, NULL};
    FTS *ftsp = NULL;
    FTSENT *fep = NULL;
    GThread *pThread = NULL;

    // gtk2ν
    Gtk::Main gMain(NULL, NULL, true);

    // gthread ν    
    if (!g_thread_supported()) g_thread_init(NULL);

    try {
        // եI/O饹ι
        FioService* fioService = FioService::getInstance(inFD, outFD);
        
        if (!fioService) {
            fprintf(stderr, "%s: Out Of Memory Error!\n", APP_NAME);
            exit(-1);
        }
        
        // ʥϥɥ
        signal(SIGTERM, sigTerm);
        signal(SIGPIPE, sigPipe);
        
        // ̿򳫻Ϥ
        pThread = g_thread_create(doServiceThread, NULL, TRUE, NULL);
        
        if (!pThread) {
            fprintf(stderr, "%s: Can't create thread.\n", APP_NAME);
            exit(-1);
        }
        
        // 䵻եɤ߹
        ftsp = fts_open(paths, FTS_LOGICAL, NULL);

        if (ftsp) {
            while (fep = fts_read(ftsp), fep != NULL) {
                if (FTS_F == fep->fts_info && fep->fts_path &&
                    strncmp(APP_NAME ".", fep->fts_name, sizeof(APP_NAME)) == 0){
                        // 䵻
                        fioService->open(fep->fts_path);
                }
            }

            fts_close(ftsp);
        }
        
        // λԤ
        fioService->waitFor();
        g_thread_join(pThread);
        
        FusenshiServer::destroy();
        FioService::destroy();
    }
    catch (char* pMessage) {
        fprintf(stderr, "%s: FIO: %s\n", APP_NAME, pMessage);
    }
    catch (const char* pMessage) {
        fprintf(stderr, "%s: FIO: %s\n", APP_NAME, pMessage);
    }
    catch (...) {
        fprintf(stderr, "%s: FIO: Unknown exception occured.\n", APP_NAME);
    }
}

/**
 * եI/Oӥμ¹ԥå
 */
static gpointer doServiceThread(gpointer data)
{
    try {
        FioService::getInstance()->run();
    }
    catch (char* pMessage) {
        fprintf(stderr, "%s: FIO: %s\n", APP_NAME, pMessage);
    }
    catch (const char* pMessage) {
        fprintf(stderr, "%s: FIO: %s\n", APP_NAME, pMessage);
    }
    catch (...) {
        fprintf(stderr, "%s: FIO: Unknown exception occured.\n", APP_NAME);
    }
    
    return NULL;
}

/**
 * SIGTERM ʥα
 */
static void sigTerm(int num)
{
    try {
        fprintf(stderr, "%s: FIO: signal %d received\n", APP_NAME, num);

        // λ
        FioService::getInstance()->stop();
    }
    catch (char* pMessage) {
        fprintf(stderr, "%s: FIO: %s\n", APP_NAME, pMessage);
    }
    catch (const char* pMessage) {
        fprintf(stderr, "%s: FIO: %s\n", APP_NAME, pMessage);
    }
    catch (...) {
        fprintf(stderr, "%s: FIO: Unknown exception occured.\n", APP_NAME);
    }
}

/**
 * SIGPIPE α
 */
static void sigPipe(int num)
{
    sigTerm(num);
}
