/*
 * $Id: fioservice.h,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___FIOSERVICE_H
#define ___FIOSERVICE_H

#include "glib.h"
#include "../include/commandid.h"
#include "../include/commandcontrol.h"
#include "../include/propertydata.h"

class FioService {
public:
    /**
     * ̿򳫻Ϥޤ
     */
    void run();
    
    /**
     * 䵻եɤ߹ߡɥץΤޤ
     * 
     * @param pFileName 䵻ե̾
     */
    void open(const char* pFileName);
    
    /**
     * ̿λޤ
     */
    void stop();
    
    /**
     * ̿δλԤޤ
     */
    void waitFor();
    
public:
    /**
     * 󥹥󥹤˴ץꥱνλ
     * Ԥޤ
     */
    static void destroy();
    
    /**
     * ۺѤFioService饹Υ󥹥󥹤ޤ
     * 
     * @return ͣΥ󥹥
     */
    static FioService* getInstance();
    
    /**
     * ɬפ˱FioService饹Υ󥹥󥹤ۤ
     * ͣΥ󥹥󥹤ޤ
     * 
     * @param inFD ɥץȤΥѥ
     * @param outFD ɥץȤΥѥ
     * @return ͣΥ󥹥
     */
    static FioService* getInstance(int inFD, int outFD);
    
    /**
     * 䵻ޤ
     * 
     * @return 䵻
     */
    static PropertyData getProperty();
    
    /**
     * 䵻ꤷľݴɤޤ
     * 
     * @param property 䵻
     */
    static void setProperty(const PropertyData& property);

public:
    /**
     * ǥȥ饯
     */
    ~FioService();
    
private:
    /**
     * 󥹥ȥ饯
     */
    FioService(int inFD, int outFD);
    
    /**
     * ޥɤޤ
     * 
     * @param lpCommand ޥ
     */
    void actionCommand(LP_COMMAND lpCommand);
    
    /**
     * ͥåȥǽͭʾ䵻極ӥ楯饹
     * ޤ
     * 
     * @return 䵻極ӥ楯饹ޤϡNULLᤷޤ
     */
    FusenshiServer* getServer();
    
    /**
     * 䵻ޤ
     * 
     * @param nFileID ե̤륤ǥå
     * @param pCommand ޥ
     */
    void printFusenshi(guint nFileID, const char* pCommand);
    
private:
    /**
     * ץѥƥѹɬפʽ¹Ԥޤ
     */
    static void updateProperty();

private:
    /**
     * ͣΥ󥹥
     */
    static FioService* m_pInstance;
    
    /**
     * 䵻
     */
    static PropertyData m_cProperty;
    
    /**
     * ¦ѥ
     */
    int m_nIn;
    
    /**
     * ¦ѥ
     */
    int m_nOut;
    
    /**
     * ̿¹Ծ
     */
    int m_bRunning;
    
    /**
     * ̿׵ե饰
     */
    int m_bStop;
    
    /**
     * Ʊѥߥ塼ƥå
     */
    GMutex* m_pMutex;
    
    /**
     * ޥ饹
     */
    CommandControl* m_pCommand;
};

#endif
