/*
 * $Id: fusenshidata.cpp,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fioservice.h"
#include "../include/fusenshidata.h"
#include "../include/propertydata.h"

#include <glib.h>

/**
 * 󥹥ȥ饯
 */
FusenshiData::FusenshiData()
{
    const int sx = gdk_screen_width();
    const int sy = gdk_screen_height();
    PropertyData property = FioService::getProperty();

    // ѿν
    m_nMajorVersion = FUSENSHIDATA_MAJOR_VERSION;
    m_nMinorVersion = FUSENSHIDATA_MINOR_VERSION;
    m_nMicroVersion = FUSENSHIDATA_MICRO_VERSION;
    
    setBackground(property.getBackground());
    setForeground(property.getForeground());
    
    m_nHeight = 200;
    m_nWidth = 300;
    m_nXPos = (sx - m_nWidth) / 2;
    m_nYPos = (sy - m_nHeight) / 2;
    
    m_nStyle = 0;
    
    m_szFontName = property.getFontName();
    m_szText.clear();
}

/**
 * ǥȥ饯
 */
FusenshiData::~FusenshiData()
{
}

/**
 * طʿޤ
 * 
 * @return طʿᤷޤ
 *         ᤵطʿϻȥΤ߲ǽǤ
 *         ѹ϶ػߤǤ
 */
const GdkColor* FusenshiData::getBackground() const
{
    return (&m_cBackground);
}

/**
 * ե̾ޤ
 * 
 * @return ե̾ᤷޤ
 *         ᤵե̾ϻȥΤ߲ǽǤ
 *         ѹ϶ػߤǤ
 */
Glib::ustring FusenshiData::getFontName() const
{
    return m_szFontName;
}

/**
 * ʿޤ
 * 
 * @return ʿᤷޤ
 *         ᤵʿϻȥΤ߲ǽǤ
 *         ѹ϶ػߤǤ
 */
const GdkColor* FusenshiData::getForeground() const
{
    return (&m_cForeground);
}

/**
 * ɥι⤵ޤ
 * 
 * @return ɥι⤵
 */
guint FusenshiData::getHeight() const
{
    return m_nHeight;
}

/**
 * ᥸㡼Сޤ
 */
guint FusenshiData::getMajorVersion() const
{
    return m_nMajorVersion;
}

/**
 * ޥʡСޤ
 */
guint FusenshiData::getMinorVersion() const
{
    return m_nMinorVersion;
}

/**
 * ޥСޤ
 */
guint FusenshiData::getMicroVersion() const
{
    return m_nMicroVersion;
}

/**
 * ɥޤ
 * 
 * @return ɥ
 */
guint FusenshiData::getStyle() const
{
    return m_nStyle;
}

/**
 * ʸޤ
 * 
 * @return ʸᤷޤ
 *         ᤵ줿֥ȤϻȥΤ߲ǽǤ
 *         ѹ϶ػߡ
 */
Glib::ustring FusenshiData::getText() const
{
    return m_szText;
}

/**
 * ɥޤ
 * 
 * @return ɥ
 */
guint FusenshiData::getWidth() const
{
    return m_nWidth;
}

/**
 * ɥXΰ֤ޤ
 * 
 * @return ɥXΰ
 */
guint FusenshiData::getXPos() const
{
    return m_nXPos;
}

/**
 * ɥYΰ֤ޤ
 * 
 * @return ɥYΰ
 */
guint FusenshiData::getYPos() const
{
    return m_nYPos;
}

/**
 * طʿꤷޤ
 * 
 * @param pColor طʿ
 */
void FusenshiData::setBackground(const GdkColor* pColor)
{
    if (!pColor) {
        throw "Null Pointer Exception.";
    }
    
    m_cBackground.pixel = pColor->pixel;
    m_cBackground.red = pColor->red;
    m_cBackground.green = pColor->green;
    m_cBackground.blue = pColor->blue;
}

/**
 * ե̾ꤷޤ
 * 
 * @param szFontName ե̾
 */
void FusenshiData::setFontName(Glib::ustring szFontName)
{
    if (0 >= szFontName.length()) {
        throw "Bad Argument Exception.";
    }
    
    m_szFontName = szFontName;
}

/**
 * ʿꤷޤ
 * 
 * @param pColor ʿ
 */
void FusenshiData::setForeground(const GdkColor* pColor)
{
    if (!pColor) {
        throw "Null Pointer Exception.";
    }
    
    m_cForeground.pixel = pColor->pixel;
    m_cForeground.red = pColor->red;
    m_cForeground.green = pColor->green;
    m_cForeground.blue = pColor->blue;
}

/**
 * ɥι⤵ꤷޤ
 * 
 * @param nHeight ɥι⤵
 */
void FusenshiData::setHeight(guint nHeight)
{
    if (0 >= nHeight) {
        throw "Bad Argument Exception.";
    }
    
    m_nHeight = nHeight;
}

/**
 * ɥꤷޤ
 * 
 * @param nStyle ɥ
 */
void FusenshiData::setStyle(guint nStyle)
{
    m_nStyle = nStyle;
}

/**
 * ʸꤷޤ
 * 
 * @param szText ʸ
 */
void FusenshiData::setText(Glib::ustring szText)
{
    m_szText = szText;
}

/**
 * ɥꤷޤ
 * 
 * @param nWidth ɥ
 */
void FusenshiData::setWidth(guint nWidth)
{
    if (0 >= nWidth) {
        throw "Bad Argument Exception.";
    }
    
    m_nWidth = nWidth;
}

/**
 * ɥXΰ֤ꤷޤ
 * 
 * @param nXPos ɥXΰ
 */
void FusenshiData::setXPos(guint nXPos)
{
    if (0 >= nXPos) {
      nXPos = 0;
    }
    
    m_nXPos = nXPos;
}

/**
 * ɥYΰ֤ꤷޤ
 * 
 * @param nYPos ɥYΰ
 */
void FusenshiData::setYPos(guint nYPos)
{
    if (0 >= nYPos) {
        nYPos = 0;
    }
    
    m_nYPos = nYPos;
}

/**
 * ꥢ饤줿䵻ǡ䵻ǡ֥Ȥ
 * ۤޤ
 * 
 * @param pData ꥢ饤ΥХ
 * @return 䵻ǡ֥ȡ
 *         פˤʤäʳ˴ɬפޤ
 */
FusenshiData* FusenshiData::buildObject(const GString* pBytes)
{
    FusenshiData* result = new FusenshiData();
    
    if (!result) {
        throw "Out of Memory Error!";
    }

    try {
        result->buildObjectCore(pBytes);
    }
    catch (char* pErrorMsg) {
        delete result;
        result = NULL;
        throw pErrorMsg;
    }
    catch (const char* pErrorMsg) {
        delete result;
        result = NULL;
        throw pErrorMsg;
    }
    catch (std::exception &e) {
        delete result;
        result = NULL;
        fprintf(stderr, "%s: std::exception: %s\n", APP_NAME, e.what());
    }
    catch (...) {
        delete result;
        result = NULL;
        fprintf(stderr, "%s: data parse error!\n", APP_NAME);
    }
    
    return result;
}

/**
 * 䵻ǡ֥Ȥ򥷥ꥢ饤ޤ
 * 
 * @param pData 䵻ǡ֥
 * @return ꥢ饤ΥХ
 *         פˤʤäʳ˴ɬפޤ
 */
GString* FusenshiData::toSerializedString(const FusenshiData* pData)
{
    GString *result = g_string_sized_new(1024);
    Glib::ustring szBuffer;
    
    if (!result) {
        throw "Out of Memory Error!";
    }
    
    // С
    g_string_append_printf(result, TYPE_VERSION ": %d.%d.%d\r\n",
                           pData->getMajorVersion(),
                           pData->getMinorVersion(),
                           pData->getMicroVersion());

    // طʿ
    toString(pData->getBackground(), szBuffer);
    g_string_append_printf
        (result, TYPE_BG_COLOR ": %s\r\n", szBuffer.c_str());

    // ʿ
    toString(pData->getForeground(), szBuffer);
    g_string_append_printf
        (result, TYPE_FG_COLOR ": %s\r\n", szBuffer.c_str());

    // ե
    g_string_append_printf(result, TYPE_FONTNAME ": %s\r\n",
                           pData->getFontName().c_str());

    // ɥݥ
    g_string_append_printf(result, TYPE_X_POS ": %d\r\n", 
                           pData->getXPos());
    g_string_append_printf(result, TYPE_Y_POS ": %d\r\n", 
                           pData->getYPos());

    // ɥ
    g_string_append_printf(result, TYPE_WIDTH ": %d\r\n",
                           pData->getWidth());
    g_string_append_printf(result, TYPE_HEIGHT ": %d\r\n",
                           pData->getHeight());

    // ɥ
    g_string_append_printf(result, TYPE_STYLE ": %d\r\n", 
                           pData->getStyle());

    // إåνü
    g_string_append(result, "\r\n");

    // ʸ
    g_string_append(result, pData->getText().c_str());

    return result;
}

/**
 * ꥢ饤줿䵻ǡ䵻ǡ֥Ȥ
 * ۤޤ
 * 
 * @param pBytes ꥢ饤ΥХ
 * @return 䵻ǡ֥ȡ
 *         פˤʤäʳ˴ɬפޤ
 */
void FusenshiData::buildObjectCore(const GString* pBytes)
{
    // Υå
    if (!pBytes) {
        throw "Null Pointer Exception.";
    }
    if (0 >= (pBytes->len)) {
        throw "Bad Argument Exception.";
    }

    // ԤȼФ
    size_t nextPos = 0;
    Glib::ustring szBuf = pBytes->str;
    Glib::ustring szLine;

    nextPos = szBuf.find_first_of("\r\n");
    while (0 <= nextPos) {
        szLine = szBuf.substr(0, nextPos);
        
        if (('\r' == szBuf[nextPos] && '\n' == szBuf[nextPos +1]) ||
            ('\n' == szBuf[nextPos] && '\r' == szBuf[nextPos +1])) {
            nextPos++;
        }
        szBuf.erase(0, nextPos +1);
        
        szLine = strTrim(szLine);
        if (0 >= szLine.length()) {
            break;
        }
        
        parseValueAndSet(szLine);
        
        nextPos = szBuf.find_first_of("\r\n");
    }
    
    // ʸ
    setText(szBuf);
}

/**
 * ꥢ饤줿䵻ǡκǾñ̤ϡꤷޤ
 * 
 * @param szLine 䵻ǡκǾñ
 */
void FusenshiData::parseValueAndSet(Glib::ustring& szLine)
{
    if (0 >= szLine.length()) {
        throw "Can't parse the data.";
    }
    
    size_t splitPos = 0;
    Glib::ustring szType;
    
    splitPos = szLine.find(':');
    
    if (0 >= splitPos) {
        throw "value type not found.";
    }

    szType = szLine.substr(0, splitPos);
    szLine.erase(0, splitPos +1);
    
    szType = strTrim(szType);
    szLine = strTrim(szLine);
    
    parseValueAndSet(szType, szLine);
}

/**
 * ꥢ饤줿䵻ǡκǾñ̤ϡꤷޤ
 * 
 * @param szType ǡ
 * @param szValue ǡ
 */
void FusenshiData::parseValueAndSet
    (Glib::ustring& szType, Glib::ustring& szValue)
{
    const guint sx = gdk_screen_width();
    const guint sy = gdk_screen_height();
    
    guint nValue = 0;

    // Version
    if (strcasecmp(szType.c_str(), TYPE_VERSION) == 0) {
        parseVersionAndSet(szValue);
    }
    // Background Color
    else if (strcasecmp(szType.c_str(), TYPE_BG_COLOR) == 0) {
        parseColorAndSet(&m_cBackground, szValue.c_str());
    }
    // Foreground Color
    else if (strcasecmp(szType.c_str(), TYPE_FG_COLOR) == 0) {
        parseColorAndSet(&m_cForeground, szValue.c_str());
    }
    // FontName
    else if (strcasecmp(szType.c_str(), TYPE_FONTNAME) == 0) {
        setFontName(szValue.c_str());
    }
    // X Pos
    else if (strcasecmp(szType.c_str(), TYPE_X_POS) == 0) {
        nValue = atoi(szValue.c_str());
        if (0 > nValue) nValue = 0;
        if (sx <= nValue) nValue = sx -1;
        
        setXPos(nValue);
    }
    // Y Pos
    else if (strcasecmp(szType.c_str(), TYPE_Y_POS) == 0) {
        nValue = atoi(szValue.c_str());
        if (0 > nValue) nValue = 0;
        if (sy <= nValue) nValue = sy -1;
        
        setYPos(nValue);
    }
    // Width
    else if (strcasecmp(szType.c_str(), TYPE_WIDTH) == 0) {
        nValue = atoi(szValue.c_str());
        if (0 >= nValue) nValue = 1;
        if (sx < nValue) nValue = sx;
        
        setWidth(nValue);
    }
    // Height
    else if (strcasecmp(szType.c_str(), TYPE_HEIGHT) == 0) {
        nValue = atoi(szValue.c_str());
        if (0 >= nValue) nValue = 1;
        if (sy < nValue) nValue = sy;
        
        setHeight(nValue);
    }
    // Style
    else if (strcasecmp(szType.c_str(), TYPE_STYLE) == 0) {
        setStyle(atoi(szValue.c_str()));
    }
}

/**
 * СʸϤơꤷޤ
 * 
 * @param szVersion Сʸ
 */
void FusenshiData::parseVersionAndSet(Glib::ustring& szVersion)
{
    size_t pos = szVersion.find('.');
    Glib::ustring number = szVersion.substr(0, pos);
    
    if (0 < pos) {
        m_nMajorVersion = atoi(number.c_str());
        
        szVersion.erase(0, pos +1);
        pos = szVersion.find('.');
        number = szVersion.substr(0, pos);
        if (0 < pos) {
            m_nMinorVersion = atoi(number.c_str());

            szVersion.erase(0, pos +1);
            m_nMicroVersion = atoi(szVersion.c_str());
        }
    }
}

/**
 * ʸ󤫤鿧ꤷޤ
 * 
 * @param pColor GdkColor¤
 * @param pValue ݻʸ
 */
void FusenshiData::parseColorAndSet(GdkColor *pColor, const char *pValue)
{
    parseColor(pColor, pValue);
}

/**
 * ʣ
 */
FusenshiData& FusenshiData::operator=(const FusenshiData& data)
{
    /**
     * С
     */
    m_nMajorVersion = data.getMajorVersion();
    m_nMinorVersion = data.getMinorVersion();
    m_nMicroVersion = data.getMicroVersion();

    /**
     * ɥȰ
     */
    setXPos(data.getXPos());
    setYPos(data.getYPos());
    setWidth(data.getWidth());
    setHeight(data.getHeight());

    /**
     * ɥ
     */
    setStyle(data.getStyle());

    /**
     * ʡطʿ
     */
    setBackground(data.getBackground());
    setForeground(data.getForeground());

    /**
     * եȾ̾
     */
    setFontName(data.getFontName());

    /**
     * ʸ
     */
    setText(data.getText());
    
    return (*this);
}

/**
 * 
 */
bool FusenshiData::operator==(const FusenshiData& data) const
{
    bool result = true;
    
    /**
     * С
     */
    result &= getMajorVersion() == data.getMajorVersion();
    result &= getMinorVersion() == data.getMinorVersion();
    result &= getMicroVersion() == data.getMicroVersion();

    /**
     * ɥȰ
     */
    result &= getXPos() == data.getXPos();
    result &= getYPos() == data.getYPos();
    result &= getWidth() == data.getWidth();
    result &= getHeight() == data.getHeight();

    /**
     * ɥ
     */
    result &= getStyle() == data.getStyle();

    /**
     * ʡطʿ
     */
    const GdkColor* pColor1 = getBackground();
    const GdkColor* pColor2 = data.getBackground();
    
    result &= (pColor1->red == pColor2->red) &&
              (pColor1->green == pColor2->green) &&
              (pColor1->blue == pColor2->blue);

    pColor1 = getForeground();
    pColor2 = data.getForeground();
    
    result &= (pColor1->red == pColor2->red) &&
              (pColor1->green == pColor2->green) &&
              (pColor1->blue == pColor2->blue);

    /**
     * եȾ̾
     */
    result &= (getFontName() == data.getFontName());

    /**
     * ʸ
     */
    result &= (getText() == data.getText());
    
    return result;
}

/**
 * 
 */
bool FusenshiData::operator!=(const FusenshiData& data) const
{
    return !(*this == data);
}
