/*
 * $Id: fusenshiloader.cpp,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshiloader.h"

/**
 * 󥹥ȥ饯
 */
FusenshiLoader::FusenshiLoader()
{
}

/**
 * ǥȥ饯
 */
FusenshiLoader::~FusenshiLoader()
{
}

/**
 * 䵻եɤ߹ߡ䵻ǡ饹ۤޤ
 * 
 * @param pFileName ե̾
 * @return 䵻ǡ饹
 */
FusenshiData* FusenshiLoader::loadFusenshiData(const char* pFileName)
{
    GString* pData = loadFusenshiFile(pFileName);
    
    if (pData) {
        FusenshiData *result = FusenshiData::buildObject(pData);
        
        g_string_free(pData, TRUE);
        
        return result;
    }
    
    return NULL;
}

/**
 * 䵻եɤ߹ߡ䵻ǡޤ
 * 
 * @param pFileName ե̾
 * @return 䵻ǡ
 */
GString* FusenshiLoader::loadFusenshiFile(const char* pFileName)
{
    if (!pFileName) {
        throw "Null Pointer Exception.";
    }
    
    // Хåեγ
    GString *pData = g_string_sized_new(1024);
    
    if (!pData) {
        throw "Out of Memory Error!";
    }
    
    // ɤ߹
    int nRead = 0;
    char buf[1024] = {0};
    FILE *fp = fopen(pFileName, "rb");
    
    if (!fp) {
        g_string_free(pData, TRUE);
        fprintf(stderr, "%s: Can't open file. %s\n",
                APP_NAME, pFileName);
        return NULL;
    }
    
    while (nRead = fread(buf, 1, sizeof(buf), fp), 0 < nRead) {
        g_string_append_len(pData, buf, nRead);
    }
    
    fclose(fp);
    
    if (0 >= pData->len) {
        g_string_append_len(pData, "\r\n", 2);
    }
    
    return pData;
}
