/*
 * $Id: fusenshisaver.cpp,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshisaver.h"
#include "filemanager.h"

#include <fcntl.h>
#include <errno.h>

static GStaticMutex g_Mutex = G_STATIC_MUTEX_INIT;

/**
 * 󥹥ȥ饯
 */
FusenshiSaver::FusenshiSaver()
{
}

/**
 * ǥȥ饯
 */
FusenshiSaver::~FusenshiSaver()
{
}

/**
 * 䵻ǡ饹ե¸ޤ
 * 
 * @param pFileName ե̾
 * @param pData 䵻ǡ饹
 */
void FusenshiSaver::saveFusenshiData
    (const char* pFileName, const FusenshiData* pData)
{
    GString* lpStrData = FusenshiData::toSerializedString(pData);
    
    if (lpStrData) {
        saveFusenshiData(pFileName, lpStrData);
        g_string_free(lpStrData, TRUE);
    }
}

/**
 * 䵻ǡե¸ޤ
 * 
 * @param pFileName ե̾
 * @param pData 䵻ǡ
 */
void FusenshiSaver::saveFusenshiData
    (const char* pFileName, const GString* pData)
{
    if (!pFileName || !pData) {
        throw "Null Pointer Exception";
    }
    
    g_static_mutex_lock(&g_Mutex);

    const char* pAppDir = getAppDir(APP_NAME);
    char pTmpFile[PATH_MAX] = {0};
    
    memset(pTmpFile, '\0', sizeof(pTmpFile));
    strncpy(pTmpFile, pAppDir, sizeof(pTmpFile) -1);
    strncat(pTmpFile, "/fusenshi_temp", sizeof(pTmpFile) -1);
    
    const int flags = O_WRONLY | O_CREAT | O_TRUNC | O_EXCL | O_EXLOCK;
    const mode_t mode = S_IRUSR | S_IWUSR;
    
    int fd = open(pTmpFile, flags, mode);
    
    if (0 > fd) {
        fprintf(stderr, "%s: Can't create file. (%s)\n",
            APP_NAME, pTmpFile);
    }
    else {
        // 񤭹
        guint nWrite = write(fd, pData->str, pData->len);
        
        close(fd);
        
        // å
        if (nWrite == pData->len) {
            // ե񤭰ư
            if (0 == rename(pTmpFile, pFileName)) {
                // 
                chmod(pFileName, mode);
            }
            else {
                // 񤭰ư˼ԡե
                remove(pTmpFile);
                
                fprintf(stderr, "%s: %s\n",
                    APP_NAME, strerror(errno));
            }
        }
        else {
            // 񤭹߼ԡե
            remove(pTmpFile);
            
            fprintf(stderr, "%s: write failed. (%s)\n",
                APP_NAME, pTmpFile);
        }
    }

    g_static_mutex_unlock(&g_Mutex);
}

/**
 * 䵻ǡ򿷵¸ޤ
 * 
 * @param 䵻ǡ
 * @return եб륤ǥå
 */
guint FusenshiSaver::saveNewFusenshiData(const GString* pData)
{
    FileManager& fm = FileManager::getInstance();
    
    guint result = 0;
    char* pFileName = fm.createFile();
    
    if (pFileName) {
        saveFusenshiData(pFileName, pData);
        
        result = fm.getIndex(pFileName);
        
        free(pFileName);
    }
    
    return result;
}
