/*
 * $Id: propertydata.cpp,v 1.1 2004/04/01 08:52:24 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "../include/fusenshidata.h"
#include "../include/propertydata.h"
#include "xmlloader.h"
#include "xmlsaver.h"

#include <netinet/in.h>
#include <arpa/inet.h>

#define PROPERTY_FILENAME "config.xml"
#define ROOT_NODE          (APP_NAME "-config")

/**
 * 󥹥ȥ饯
 */
PropertyData::PropertyData()
{
    const char* pUserName = getenv("USER");
    m_szNickName = (pUserName ? pUserName : "unknown");

    m_cBackground.pixel = 0;
    m_cBackground.red = 0xffff;
    m_cBackground.green = 0xffff;
    m_cBackground.blue = 0xcccc;
    
    m_cForeground.pixel = 0;
    m_cForeground.red = 0x0000;
    m_cForeground.green = 0x0000;
    m_cForeground.blue = 0x0000;

    m_szFontName = DEFAULT_FONTNAME;

    m_szPrintCommand = DEFAULT_PRINT_COMMAND;

    m_bEnableNetwork = true;
    m_cBroadcastList.push_back(IP2STR(INADDR_BROADCAST));
}

/**
 * ǥȥ饯
 */
PropertyData::~PropertyData()
{
}

/**
 * ֥ɥ㥹ȥɥ쥹ɲäޤ
 * 
 * @param szAddr ֥ɥ㥹ȥɥ쥹
 */
void PropertyData::addBroadcastAddr(Glib::ustring szAddr)
{
    m_cBroadcastList.push_back(szAddr);
}

/**
 * ֥ɥ㥹ȥɥ쥹ΰˤޤ
 */
void PropertyData::clearBroadcastList()
{
    m_cBroadcastList.clear();
}

/**
 * طʿޤ
 * 
 * @return طʿᤷޤ
 *         ᤵطʿϻȥΤ߲ǽǤ
 *         ѹ϶ػߤǤ
 */
const GdkColor* PropertyData::getBackground() const
{
    return &m_cBackground;
}

/**
 * ֥ɥ㥹ȥɥ쥹ΰޤ
 * 
 * @return ֥ɥ㥹ȥɥ쥹ΰ
 */
const BroadcastList& PropertyData::getBroadcastList() const
{
    return m_cBroadcastList;
}

/**
 * ե̾ޤ
 * 
 * @return ե̾ᤷޤ
 */
Glib::ustring PropertyData::getFontName() const
{
    return m_szFontName;
}

/**
 * ʿޤ
 * 
 * @return ʿᤷޤ
 *         ᤵʿϻȥΤ߲ǽǤ
 *         ѹ϶ػߤǤ
 */
const GdkColor* PropertyData::getForeground() const
{
    return &m_cForeground;
}

/**
 * ˥å͡ޤ
 * 
 * @return ˥å͡ᤷޤ
 */
Glib::ustring PropertyData::getNickName() const
{
    return m_szNickName;
}

/**
 * ѤΥޥɤޤ
 * 
 * @return ѤΥޥɤᤷޤ
 */
Glib::ustring PropertyData::getPrintCommand() const
{
    return m_szPrintCommand;
}

/**
 * ͥåȥǽѤ뤫Ĵ٤ޤ
 * 
 * @return ͥåȥǽͭʾ true ᤷޤ
 */
bool PropertyData::isEnableNetwork() const
{
    return m_bEnableNetwork;
}

/**
 * ֥ɥ㥹ȥɥ쥹ΰꤷޤ
 * 
 * @param broadcastList ֥ɥ㥹ȥɥ쥹ΰ
 */
void PropertyData::setBroadcastList(const BroadcastList& broadcastList)
{
    BroadcastList& list = (BroadcastList&)broadcastList;
    BroadcastList::iterator iter = list.begin();

    m_cBroadcastList.clear();

    for (; iter != list.end(); iter++) {
        m_cBroadcastList.push_back(*iter);
    }
}

/**
 * طʿꤷޤ
 * 
 * @param pColor طʿ
 */
void PropertyData::setBackground(const GdkColor* pColor)
{
    if (!pColor) {
        throw "Null Pointer Exception.";
    }
    
    m_cBackground.pixel = pColor->pixel;
    m_cBackground.red = pColor->red;
    m_cBackground.green = pColor->green;
    m_cBackground.blue = pColor->blue;
}

/**
 * ͥåȥǽѤ뤫ꤷޤ
 * 
 * @param bEnable ͥåȥǽͭˤ true ꤷޤ
 */
void PropertyData::setEnableNetwork(bool bEnable)
{
    m_bEnableNetwork = bEnable;
}

/**
 * ե̾ꤷޤ
 * 
 * @param szFontName ե̾
 */
void PropertyData::setFontName(Glib::ustring szFontName)
{
    m_szFontName = szFontName;
}

/**
 * ʿꤷޤ
 * 
 * @param pColor ʿ
 */
void PropertyData::setForeground(const GdkColor* pColor)
{
    if (!pColor) {
        throw "Null Pointer Exception.";
    }
    
    m_cForeground.pixel = pColor->pixel;
    m_cForeground.red = pColor->red;
    m_cForeground.green = pColor->green;
    m_cForeground.blue = pColor->blue;
}

/**
 * ˥å͡ꤷޤ
 * 
 * @param szNickName ˥å͡
 */
void PropertyData::setNickName(const Glib::ustring szNickName)
{
    m_szNickName = szNickName;
}

/**
 * ѤΥޥɤޤ
 * 
 * @return ѤΥޥɤᤷޤ
 */
void PropertyData::setPrintCommand(const Glib::ustring szPrintCommand)
{
    m_szPrintCommand = szPrintCommand;
}

/**
 * ʣ
 */
PropertyData& PropertyData::operator=(const PropertyData& data)
{
    // ˥å͡
    setNickName(data.getNickName());

    // ʡطʿ
    setBackground(data.getBackground());
    setForeground(data.getForeground());

    // եȾ̾
    setFontName(data.getFontName());

    // ޥ
    setPrintCommand(data.getPrintCommand());

    // ͥåȥͭե饰
    setEnableNetwork(data.isEnableNetwork());

    // ֥ɥ㥹ȥɥ쥹
    setBroadcastList(data.getBroadcastList());

    return (*this);
}

/**
 * 
 */
bool PropertyData::operator==(const PropertyData& data) const
{
    bool result = true;

    // ˥å͡
    result &= (getNickName() == data.getNickName());

    // ʡطʿ
    const GdkColor* pColor1 = getBackground();
    const GdkColor* pColor2 = data.getBackground();
    
    result &= (pColor1->red == pColor2->red) &&
              (pColor1->green == pColor2->green) &&
              (pColor1->blue == pColor2->blue);

    pColor1 = getForeground();
    pColor2 = data.getForeground();
    
    result &= (pColor1->red == pColor2->red) &&
              (pColor1->green == pColor2->green) &&
              (pColor1->blue == pColor2->blue);

    // եȾ̾
    result &= (getFontName() == data.getFontName());

    // ޥ
    result &= (getPrintCommand() == data.getPrintCommand());

    // ͥåȥͭե饰
    result &= (isEnableNetwork() == data.isEnableNetwork());

    // ֥ɥ㥹ȥꥹ
    BroadcastList& list1 = (BroadcastList&)getBroadcastList();
    BroadcastList& list2 = (BroadcastList&)data.getBroadcastList();
    BroadcastList::iterator iter1 = list1.begin();
    BroadcastList::iterator iter1end = list1.end();
    BroadcastList::iterator iter2 = list2.begin();
    BroadcastList::iterator iter2end = list2.end();

    for (; iter1 != iter1end && iter2 != iter2end; iter1++, iter2++) {
        result &= (*iter1 == *iter2);
    }

    result &= (iter1 == iter1end && iter2 == iter2end);

    return result;
}

/**
 * 
 */
bool PropertyData::operator!=(const PropertyData& data) const
{
    return !(*this == data);
}

/**
 * 䵻Υץѥƥɤ߹ߤޤ
 * 
 * @return ɤ䵻Υץѥƥᤷޤ
 */
PropertyData PropertyData::loadProperty()
{
    PropertyData property;

    // 䵻ե̾ι
    Glib::ustring szPropFile = getAppDir(APP_NAME);
    szPropFile += "/";
    szPropFile += PROPERTY_FILENAME;

    // ɤ߹
    xmlDocPtr doc = XMLLoader::load(szPropFile);

    if (!doc) {
        throw "Can't load property file.";
    }

    // 
    const char *key = NULL;
    xmlNodePtr node = xmlDocGetRootElement(doc);

    if (xmlStrcmp(node->name, (const xmlChar *)ROOT_NODE)) {
        xmlFreeDoc(doc);
        throw "Property file is broken.";
    }

    node = node->xmlChildrenNode;

    property.clearBroadcastList();

    while (node) {
        key = (char*)xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
        if (!xmlStrcmp(node->name, (const xmlChar *)PTYPE_NICKNAME)) {
            property.setNickName(key);
        }
        else if (!xmlStrcmp(node->name, (const xmlChar *)PTYPE_BG_COLOR)) {
            parseColor(&property.m_cBackground, key);
        }
        else if (!xmlStrcmp(node->name, (const xmlChar *)PTYPE_FG_COLOR)) {
            parseColor(&property.m_cForeground, key);
        }
        else if (!xmlStrcmp(node->name, (const xmlChar *)PTYPE_FONTNAME)) {
            property.setFontName(key);
        }
        else if (!xmlStrcmp(node->name, (const xmlChar *)PTYPE_PRINT_COMMAND)) {
            property.setPrintCommand(key);
        }
        else if (!xmlStrcmp(node->name, (const xmlChar *)PTYPE_ENABLE_NETWORK)) {
            property.setEnableNetwork
                (strcasecmp(key, "true") == 0 || strcmp(key, "1") == 0);
        }
        else if (!xmlStrcmp(node->name, (const xmlChar *)PTYPE_BROADCAST_ADDR)) {
            property.addBroadcastAddr(key);
        }
        xmlFree((xmlChar*)key);

        node = node->next;
    }

    xmlFreeDoc(doc);

    return property;
}

/**
 * 䵻Υץѥƥ¸ޤ
 * 
 * @param property 䵻ץѥƥ
 * @return ¸ true ᤷޤ
 */
bool PropertyData::saveProperty(const PropertyData& property)
{
    // 䵻ե̾ι
    Glib::ustring szPropFile = getAppDir(APP_NAME);
    szPropFile += "/";
    szPropFile += PROPERTY_FILENAME;

    // ¸ѤΥǥ쥯ȥ
    createFusenshiDir();

    // XMLɥȤι
    xmlDocPtr doc = xmlNewDoc((xmlChar*)"1.0");

    Glib::ustring szBuffer;

    doc->children = xmlNewDocNode(doc, NULL, (xmlChar*)ROOT_NODE, NULL);

    xmlNewChild(doc->children, NULL, (xmlChar*)PTYPE_NICKNAME,
                (xmlChar*)property.getNickName().c_str());

    toString(property.getBackground(), szBuffer);
    xmlNewChild(doc->children, NULL, (xmlChar*)PTYPE_BG_COLOR,
                (xmlChar*)szBuffer.c_str());

    toString(property.getForeground(), szBuffer);
    xmlNewChild(doc->children, NULL, (xmlChar*)PTYPE_FG_COLOR,
                (xmlChar*)szBuffer.c_str());

    xmlNewChild(doc->children, NULL, (xmlChar*)PTYPE_FONTNAME,
                (xmlChar*)property.getFontName().c_str());

    xmlNewChild(doc->children, NULL, (xmlChar*)PTYPE_PRINT_COMMAND,
                (xmlChar*)property.getPrintCommand().c_str());

    xmlNewChild(doc->children, NULL, (xmlChar*)PTYPE_ENABLE_NETWORK,
                (xmlChar*)(property.isEnableNetwork() ? "true" : "false"));

    BroadcastList& list = (BroadcastList&)property.getBroadcastList();
    BroadcastList::iterator iter = list.begin();
    BroadcastList::iterator iterend = list.end();

    for (; iter != iterend; iter++) {
        xmlNewChild(doc->children, NULL, (xmlChar*)PTYPE_BROADCAST_ADDR,
                    (xmlChar*)(*iter).c_str());
    }

    bool result = XMLSaver::save(szPropFile, doc);

    xmlFreeDoc(doc);

    return result;
}
