/*
 * $Id: fusenshidata.h,v 1.1 2004/04/01 08:52:40 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___FUSENSHIDATA_H
#define ___FUSENSHIDATA_H

#include "glib.h"
#include "gdk/gdk.h"

#define FUSENSHIDATA_MAJOR_VERSION      0
#define FUSENSHIDATA_MINOR_VERSION      7
#define FUSENSHIDATA_MICRO_VERSION      0

#define DEFAULT_FONTNAME    "Gothic 10"

#define TYPE_VERSION    "Version"
#define TYPE_BG_COLOR   "Background-Color"
#define TYPE_FG_COLOR   "Foreground-Color"
#define TYPE_FONTNAME   "FontName"
#define TYPE_X_POS      "WindowPos-X"
#define TYPE_Y_POS      "WindowPos-Y"
#define TYPE_WIDTH      "WindowSize-Width"
#define TYPE_HEIGHT     "WindowSize-Height"
#define TYPE_STYLE      "Window-Style"

class FusenshiData {
public:
    /**
     * 󥹥ȥ饯
     */
    FusenshiData();

    /**
     * ǥȥ饯
     */
    virtual ~FusenshiData();

    /**
     * طʿޤ
     * 
     * @return طʿᤷޤ
     *         ᤵطʿϻȥΤ߲ǽǤ
     *         ѹ϶ػߤǤ
     */
    const GdkColor* getBackground() const;

    /**
     * 䵻ե̾ޤ
     * 
     * @return 䵻ե̾
     */
    Glib::ustring getFileName() const;
    
    /**
     * ե̾ޤ
     * 
     * @return ե̾ᤷޤ
     */
    Glib::ustring getFontName() const;
    
    /**
     * ʿޤ
     * 
     * @return ʿᤷޤ
     *         ᤵʿϻȥΤ߲ǽǤ
     *         ѹ϶ػߤǤ
     */
    const GdkColor* getForeground() const;

    /**
     * ɥι⤵ޤ
     * 
     * @return ɥι⤵
     */
    guint getHeight() const;
    
    /**
     * ᥸㡼Сޤ
     */
    guint getMajorVersion() const;
    
    /**
     * ޥʡСޤ
     */
    guint getMinorVersion() const;
    
    /**
     * ޥСޤ
     */
    guint getMicroVersion() const;

    /**
     * ɥޤ
     * 
     * @return ɥ
     */
    guint getStyle() const;

    /**
     * ʸޤ
     * 
     * @return ʸᤷޤ
     */
    Glib::ustring getText() const;
    
    /**
     * ɥޤ
     * 
     * @return ɥ
     */
    guint getWidth() const;
    
    /**
     * ɥXΰ֤ޤ
     * 
     * @return ɥXΰ
     */
    guint getXPos() const;
    
    /**
     * ɥYΰ֤ޤ
     * 
     * @return ɥYΰ
     */
    guint getYPos() const;
    
    /**
     * طʿꤷޤ
     * 
     * @param pColor طʿ
     */
    void setBackground(const GdkColor* pColor);

    /**
     * ե̾ꤷޤ
     * 
     * @param szFontName ե̾
     */
    void setFontName(Glib::ustring szFontName);

    /**
     * ʿꤷޤ
     * 
     * @param pColor ʿ
     */
    void setForeground(const GdkColor* pColor);

    /**
     * ɥι⤵ꤷޤ
     * 
     * @param nHeight ɥι⤵
     */
    void setHeight(guint nHeight);
    
    /**
     * ɥꤷޤ
     * 
     * @param nStyle ɥ
     */
    void setStyle(guint nStyle);

    /**
     * ʸꤷޤ
     * 
     * @param szText ʸ
     */
    void setText(Glib::ustring szText);
    
    /**
     * ɥꤷޤ
     * 
     * @param nWidth ɥ
     */
    void setWidth(guint nWidth);
    
    /**
     * ɥXΰ֤ꤷޤ
     * 
     * @param nXPos ɥXΰ
     */
    void setXPos(guint nXPos);
    
    /**
     * ɥYΰ֤ꤷޤ
     * 
     * @param nYPos ɥYΰ
     */
    void setYPos(guint nYPos);
    
public:
    /**
     * ʣ
     */
    FusenshiData& operator=(const FusenshiData& data);
    
    /**
     * 
     */
    bool operator==(const FusenshiData& data) const;

    /**
     * 
     */
    bool operator!=(const FusenshiData& data) const;

public:
    /**
     * ꥢ饤줿䵻ǡ䵻ǡ֥Ȥ
     * ۤޤ
     * 
     * @param pBytes ꥢ饤ΥХ
     * @return 䵻ǡ֥ȡ
     *         פˤʤäʳ˴ɬפޤ
     */
    static FusenshiData* buildObject(const GString* pBytes);

    /**
     * 䵻ǡ֥Ȥ򥷥ꥢ饤ޤ
     * 
     * @param pData 䵻ǡ֥
     * @return ꥢ饤ΥХ
     *         פˤʤäʳ˴ɬפޤ
     */
    static GString* toSerializedString(const FusenshiData* pData);

protected:
    /**
     * ꥢ饤줿䵻ǡ䵻ǡ֥Ȥ
     * ۤޤ
     * 
     * @param pBytes ꥢ饤ΥХ
     */
    virtual void buildObjectCore(const GString* pBytes);
    
    /**
     * ꥢ饤줿䵻ǡκǾñ̤ϡꤷޤ
     * 
     * @param szLine 䵻ǡκǾñ
     */
    virtual void parseValueAndSet(Glib::ustring& szLine);
    
    /**
     * ꥢ饤줿䵻ǡκǾñ̤ϡꤷޤ
     * 
     * @param szType ǡ
     * @param szValue ǡ
     */
    virtual void parseValueAndSet
        (Glib::ustring& szType, Glib::ustring& szValue);
    
    /**
     * СʸϤơꤷޤ
     * 
     * @param szVersion Сʸ
     */
    virtual void parseVersionAndSet(Glib::ustring& szVersion);
    
    /**
     * ʸ󤫤鿧ꤷޤ
     * 
     * @param pColor GdkColor¤
     * @param pValue ݻʸ
     */
    virtual void parseColorAndSet(GdkColor *pColor, const char *pValue);
    
private:
    /**
     * С
     */
    guint m_nMajorVersion;
    guint m_nMinorVersion;
    guint m_nMicroVersion;

    /**
     * ɥȰ
     */
    guint m_nXPos;
    guint m_nYPos;
    guint m_nWidth;
    guint m_nHeight;

    /**
     * ɥ
     */
    guint m_nStyle;

    /**
     * ʡطʿ
     */
    GdkColor m_cForeground;
    GdkColor m_cBackground;

    /**
     * եȾ̾
     */
    Glib::ustring m_szFontName;

    /**
     * ʸ
     */
    Glib::ustring m_szText;
};

#endif
