/*
 * $Id: propertydata.h,v 1.1 2004/04/01 08:52:40 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 *
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___PROPERTYDATA_H
#define ___PROPERTYDATA_H

#include <gtkmm.h>

#define PTYPE_NICKNAME            "Nickname"
#define PTYPE_BG_COLOR            "Background-Color"
#define PTYPE_FG_COLOR            "Foreground-Color"
#define PTYPE_FONTNAME            "FontName"
#define PTYPE_PRINT_COMMAND       "PrintCommand"
#define PTYPE_ENABLE_NETWORK      "EnableNetwork"
#define PTYPE_BROADCAST_ADDR      "BroadcastAddr"

typedef std::list<Glib::ustring>    BroadcastList;

class PropertyData {
public:
    /**
     * 󥹥ȥ饯
     */
    PropertyData();

    /**
     * ǥȥ饯
     */
    virtual ~PropertyData();

    /**
     * ֥ɥ㥹ȥɥ쥹ɲäޤ
     * 
     * @param szAddr ֥ɥ㥹ȥɥ쥹
     */
    void addBroadcastAddr(Glib::ustring szAddr);

    /**
     * ֥ɥ㥹ȥɥ쥹ΰˤޤ
     */
    void clearBroadcastList();

    /**
     * طʿޤ
     * 
     * @return طʿᤷޤ
     *         ᤵطʿϻȥΤ߲ǽǤ
     *         ѹ϶ػߤǤ
     */
    const GdkColor* getBackground() const;

    /**
     * ֥ɥ㥹ȥɥ쥹ΰޤ
     * 
     * @return ֥ɥ㥹ȥɥ쥹ΰ
     */
    const BroadcastList& getBroadcastList() const;

    /**
     * ե̾ޤ
     * 
     * @return ե̾ᤷޤ
     */
    Glib::ustring getFontName() const;
    
    /**
     * ʿޤ
     * 
     * @return ʿᤷޤ
     *         ᤵʿϻȥΤ߲ǽǤ
     *         ѹ϶ػߤǤ
     */
    const GdkColor* getForeground() const;
    
    /**
     * ˥å͡ޤ
     * 
     * @return ˥å͡ᤷޤ
     */
    Glib::ustring getNickName() const;

    /**
     * ѤΥޥɤޤ
     * 
     * @return ѤΥޥɤᤷޤ
     */
    Glib::ustring getPrintCommand() const;

    /**
     * ͥåȥǽѤ뤫Ĵ٤ޤ
     * 
     * @return ͥåȥǽͭʾ true ᤷޤ
     */
    bool isEnableNetwork() const;

    /**
     * ֥ɥ㥹ȥɥ쥹ΰꤷޤ
     * 
     * @param broadcastList ֥ɥ㥹ȥɥ쥹ΰ
     */
    void setBroadcastList(const BroadcastList& broadcastList);

    /**
     * طʿꤷޤ
     * 
     * @param pColor طʿ
     */
    void setBackground(const GdkColor* pColor);

    /**
     * ͥåȥǽѤ뤫ꤷޤ
     * 
     * @param bEnable ͥåȥǽͭˤ true ꤷޤ
     */
    void setEnableNetwork(bool bEnable);

    /**
     * ե̾ꤷޤ
     * 
     * @param szFontName ե̾
     */
    void setFontName(Glib::ustring szFontName);

    /**
     * ʿꤷޤ
     * 
     * @param pColor ʿ
     */
    void setForeground(const GdkColor* pColor);

    /**
     * ˥å͡ꤷޤ
     * 
     * @param szNickName ˥å͡
     */
    void setNickName(const Glib::ustring szNickName);

    /**
     * ѤΥޥɤޤ
     * 
     * @param szPrintCommand ѤΥޥ
     */
    void setPrintCommand(const Glib::ustring szPrintCommand);

public:
    /**
     * ʣ
     */
    PropertyData& operator=(const PropertyData& data);
    
    /**
     * 
     */
    bool operator==(const PropertyData& data) const;

    /**
     * 
     */
    bool operator!=(const PropertyData& data) const;

public:
    /**
     * 䵻Υץѥƥɤ߹ߤޤ
     * 
     * @return ɤ䵻Υץѥƥᤷޤ
     */
    static PropertyData loadProperty();

    /**
     * 䵻Υץѥƥ¸ޤ
     * 
     * @param property 䵻ץѥƥ
     * @return ¸ true ᤷޤ
     */
    static bool saveProperty(const PropertyData& property);

private:
    /**
     * ˥å͡
     */
    Glib::ustring m_szNickName;

    /**
     * ʡطʿ
     */
    GdkColor m_cForeground;
    GdkColor m_cBackground;

    /**
     * եȾ̾
     */
    Glib::ustring m_szFontName;

    /**
     * ͥåȥǽͭե饰
     */
    bool m_bEnableNetwork;

    /**
     * ޥ
     */
    Glib::ustring m_szPrintCommand;

    /**
     * ֥ɥ㥹ȥɥ쥹ΰ
     */
    BroadcastList m_cBroadcastList;
};

#endif
