/* 
 * $Id: main.cpp,v 1.1 2004/04/01 08:52:08 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "include/fusenshi.h"
#include "include/propertydata.h"
#include "misc/resourceloader.h"

#include "gdk/gdk.h"

#include <locale.h>

static int parseInt(const char *pVal, char **ppEndPos);
static void print_usage();

/**
 * ᥤ
 * 
 * @author $Author: daichi $
 * @version $Revision: 1.1 $
 */
int main(int argc, char *argv[])
{
    char opt = 0;
    char *tmp = NULL;

    int fdes1[2] = {0, 0};
    int fdes2[2] = {0, 0};

    WND_GLOBAL_PROP wndProp = {
        0, 0, WND_TYPE_NORMAL
    };

#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif

    ResourceLoader::addPixmapDir(PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
    ResourceLoader::addPixmapDir("./pixmaps");
    ResourceLoader::addPixmapDir("./");

    // analysis command line
    while ((opt = getopt(argc, argv, "hg:S:")) != -1) {
        switch (opt) {
        case 'g': // window poisition
            if (optarg) {
                /* X */
                wndProp.initWndPosX = parseInt(optarg, &tmp);

                /* Y */
                wndProp.initWndPosY = parseInt(tmp, NULL);
            }
            break;
        case 'S': // fusenshi window shape
            if (optarg) {
                if (strcasecmp("simple", optarg) == 0) {
                    wndProp.wndType = WND_TYPE_SIMPLE;
                }
                else if (strcasecmp("normal", optarg) == 0) {
                    wndProp.wndType = WND_TYPE_NORMAL;
                }
                else {
                    print_usage();
                    exit(-1);
                }
            }
            break;
        case 'h':
            print_usage();
            exit(0);
            break;
        default:
            print_usage();
            exit(-1);
            break;
        }
    }

    // 䵻Υץѥƥե
    {
        bool bError = false;
      
        try {
            PropertyData::loadProperty();
        }
        catch (...) {
            bError = true;
        }
      
        // ץѥƥեι
        if (bError) {
            PropertyData property;
            PropertyData::saveProperty(property);
        }
    }

    // ץ̿ѤΥѥפ
    if (-1 == pipe(fdes1)) {
        fprintf(stderr, "%s: Can't create pipe.\n", APP_NAME);
        exit(-1);
    }
    if (-1 == pipe(fdes2)) {
        fprintf(stderr, "%s: Can't create pipe.\n", APP_NAME);
        exit(-1);
    }

    // եץ()ȡɥץ()ʬΥ롣
    switch (fork()) {
    case -1: // error
        fprintf(stderr, "%s: fork() failed.\n", APP_NAME);
        exit(-1);
        break;
    case 0:  // child process
        close(fdes1[1]);
        close(fdes2[0]);
        windowServiceStart(fdes1[0], fdes2[1], &wndProp);
        close(fdes1[0]);
        close(fdes2[1]);
        fprintf(stdout, "%s: WND process exit.\n", APP_NAME);
        break;
    default: // parent process
        close(fdes1[0]);
        close(fdes2[1]);
        fioServiceStart(fdes2[0], fdes1[1]);
        close(fdes1[1]);
        close(fdes2[0]);
        fprintf(stdout, "%s: FIO process exit.\n", APP_NAME);
        break;
    }

    return 0;
}

/**
 * ʸ󤫤ͤѡޤ
 * 
 * @param pVal ʸ
 * @param ppEndPos ʸνü֡פʾ NULL ǽ
 * @return 
 */
static int parseInt(const char *pVal, char **ppEndPos)
{
    int result = 0;
    int rflag = 1;

    if ('+' == *pVal) {
        pVal++;
    }
    else if ('-' == *pVal) {
        pVal++;
        rflag = -1;
    }

    for (; *pVal >= '0' && *pVal <= '9'; pVal++) {
        result = result * 10 + (*pVal - '0');
    }
  
    if (ppEndPos) {
        *ppEndPos = (char *)pVal;
    }

    return (result * rflag);
}

/**
 * ȤϤޤ
 */
static void print_usage()
{
    printf("%s version %d.%d.%d by ONGS Inc.\n"
           "Usage: %s [-h] [-g geometry] [-S normal | simple]\n"
           "\t-h : show help\n"
           "\t-g : geometry ([+|-]x[+|-]y)\n"
           "\t-S : window shape (default: normal)\n"
           "\n",
           APP_NAME,
           FUSENSHI_MAJOR_VERSION, FUSENSHI_MINOR_VERSION,
           FUSENSHI_MICRO_VERSION, APP_NAME);
}
