/*
 * $Id: commandcontrol.cpp,v 1.1 2004/04/01 08:52:58 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 *
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "../include/commandcontrol.h"

#include <netinet/in.h>

/**
 * 󥹥ȥ饯
 */
CommandControl::CommandControl()
{
    m_pCommands = g_queue_new();
    
    if (!m_pCommands) {
        throw "Out of Memory Error!";
    }
    
    m_pMutex = g_mutex_new();
    
    if (!m_pMutex) {
        throw "Can't create mutex!";
    }
}

/**
 * ǥȥ饯
 */
CommandControl::~CommandControl()
{
    if (m_pMutex) {
        g_mutex_free(m_pMutex);
    }
    
    if (m_pCommands) {
        gpointer pData = NULL;
        
        while (pData = g_queue_pop_head(m_pCommands), pData) {
            destroyCommand((LP_COMMAND)pData);
        }
    }
}

/**
 * ޥɤ򥭥塼ɲäޤ
 * 
 * @param nCommandID ޥID
 * @param nFileID оݤΥեID
 * @param pData ޥɤ˸ͭΥǡ
 */
void CommandControl::addCommand(guint nCommandID, guint nFileID,
                                gpointer pData)
{
    LP_COMMAND lpCommand = (LP_COMMAND)g_malloc0(sizeof(COMMAND));

    if (!lpCommand) {
        throw "Out of Memory Error!";
    }
    
    lpCommand->nCommandID = nCommandID;
    lpCommand->nFileID = nFileID;
    lpCommand->pData = pData;
    
    g_mutex_lock(m_pMutex);
    g_queue_push_tail(m_pCommands, (gpointer)lpCommand);
    g_mutex_unlock(m_pMutex);
}

/**
 * ޥɤ˴ޤ
 * 
 * @param lpCommand ޥ
 */
void CommandControl::destroyCommand(LP_COMMAND lpCommand)
{
    if (!lpCommand) return;
    
    switch (lpCommand->nCommandID) {
    case CREATE_NEW_FUSENSHI_WINDOW:
    case SAVE_FUSENSHI:
    case VERIFY_RECEIVE_DATA:
    case PRINT_FUSENSHI:
        g_string_free((GString*)lpCommand->pData, TRUE);
        break;
    case CREATE_NEW_FUSENSHI:
    case DELETE_FUSENSHI:
    case EXIT_APP:
    case PROPERTY_CHANGED:
    default:
        break;
    }
    
    g_free(lpCommand);
}

/**
 * ƬΥޥɤ򣱤ĥ塼Фޤ
 * 
 * @return ޥ
 */
LP_COMMAND CommandControl::getCommand()
{
    LP_COMMAND result = NULL;
    
    g_mutex_lock(m_pMutex);
    result = (LP_COMMAND)g_queue_pop_head(m_pCommands);
    g_mutex_unlock(m_pMutex);
    
    return result;
}

/**
 * ޥɤޤ
 * 
 * @return ޥɡޥɤǤʤ NULL
 */
LP_COMMAND CommandControl::receiveCommand(int nIn)
{
    LP_COMMAND result = NULL;
    guint nCmdHead[3];
    guint nDataLen = 0;
    gpointer pData = NULL;
    
    int bError = FALSE;
    char *pErrorMsg = "pipe read error.";
    
    fd_set fdset;
    struct timeval waitTime = {0, 25 * 1000 /* 25ms */};
    
    FD_ZERO(&fdset);
    FD_SET(nIn, &fdset);
    
    switch (select(nIn +1, &fdset, NULL, NULL, &waitTime)) {
    case -1:
        bError = TRUE;
        break;
    default:
        break;
    case 1:
        result = (LP_COMMAND)g_malloc0(sizeof(COMMAND));
        
        if (!result) {
            throw "Out of Memory Error!";
        }
        
        if (sizeof(nCmdHead) != read(nIn, nCmdHead, sizeof(nCmdHead))) {
            bError = TRUE;
            break;
        }
        
        nDataLen = ntohl(nCmdHead[0]);
        if ((sizeof(guint) *2) > nDataLen) {
            bError = TRUE;
            break;
        }
        
        nDataLen -= sizeof(guint) *2;
        result->nCommandID = ntohl(nCmdHead[1]);
        result->nFileID = ntohl(nCmdHead[2]);

        if (0 < nDataLen) {
            pData = g_malloc0(nDataLen);
            if (!pData) {
                bError = TRUE;
                pErrorMsg = "Out of Memory Error!";
                break;
            }

            if (nDataLen != (guint)read(nIn, pData, nDataLen)) {
                g_free(pData);
                bError = TRUE;
                break;
            }
        }

        switch (result->nCommandID) {
        case CREATE_NEW_FUSENSHI_WINDOW:
        case SAVE_FUSENSHI:
        case VERIFY_RECEIVE_DATA:
        case PRINT_FUSENSHI:
            if (!pData) {
                bError = TRUE;
                break;
            }
            result->pData = g_string_new_len((char*)pData, nDataLen);
            if (!result->pData) {
                bError = TRUE;
                pErrorMsg = "Out of Memory Error.";
            }
            break;
        case CREATE_NEW_FUSENSHI:
        case DELETE_FUSENSHI:
        case EXIT_APP:
        case PROPERTY_CHANGED:
        default:
            result->pData = NULL;
            break;
        }
        
        if (pData) {
            g_free(pData);
        }
        break;
    }
    
    if (bError) {
        if (result) {
            g_free(result);
            result = NULL;
        }
        
        // ɤ߼ꥨ顼Τޤ
        throw pErrorMsg;
    }
    
    return result;
}

/**
 * ޥɤޤ
 * 
 * @param lpCommand ޥ
 */
void CommandControl::sendCommand(int nOut, const LP_COMMAND lpCommand)
{
    if (!lpCommand) return;

    guint nCmdHead[3];
    guint nDataLen = 0;
    gpointer pData = NULL;
    
    GString* lpString = NULL;
    
    switch (lpCommand->nCommandID) {
    case CREATE_NEW_FUSENSHI_WINDOW:
    case SAVE_FUSENSHI:
    case VERIFY_RECEIVE_DATA:
    case PRINT_FUSENSHI:
        lpString = (GString*)lpCommand->pData;
        nDataLen = lpString->len;
        pData = lpString->str;
        break;
    case CREATE_NEW_FUSENSHI:
    case DELETE_FUSENSHI:
    case EXIT_APP:
    case PROPERTY_CHANGED:
    default:
        break;
    }

    nCmdHead[0] = htonl((sizeof(guint) * 2) + nDataLen);
    nCmdHead[1] = htonl(lpCommand->nCommandID);
    nCmdHead[2] = htonl(lpCommand->nFileID);

    if (0 > write(nOut, nCmdHead, sizeof(nCmdHead)) ||
        (0 < nDataLen && 0 > write(nOut, pData, nDataLen))) {
        // 񤭹ߥ顼Τޤ
        throw "pipe write error.";
    }
}
