/*
 * $Id: resourceloader.cpp,v 1.1 2004/04/01 08:52:58 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "resourceloader.h"

#include "gtk/gtk.h"

/**
 * PixmapѤΥ꥽ǥ쥯ȥ
 */
GList* ResourceLoader::m_pPixmapDirs = NULL;

/**
 * GtkPixmap ۤޤ
 * 
 * @param pWidget å
 * @param pFileName Pixmapե̾ 
 * @return ۤGtkPixmap
 */
Gtk::Image* ResourceLoader::createImage(const char* pFileName)
{
    std::string path;

    if (!pFileName || !pFileName[0]) {
      return (new Gtk::Image());
    }

    path = findPixmapFile(pFileName);

    if (0 >= path.length()) {
      return (new Gtk::Image());
    }

    return (new Gtk::Image(path));
}

/**
 * GdkPixbuf ۤޤ
 * 
 * @param pFileName Pixbufե̾
 * @return ۤGdkPixbuf
 */
Glib::RefPtr<Gdk::Pixbuf> ResourceLoader::createPixbuf(const char* pFileName)
{
    std::string path;

    if (!pFileName || !pFileName[0]) {
        throw "Argument Exception.";
    }

    path = findPixmapFile(pFileName);

    if (0 >= path.length()) {
        throw "Pixbuf file not found.";
    }

    return Gdk::Pixbuf::create_from_file(path);
}

/**
 * Pixmapե꥽ǥ쥯ȥõޤ
 * 
 * @param pFileName Pixmapե̾
 * @return ȯPixmapեΥѥ
 */
const char* ResourceLoader::findPixmapFile(const char* pFileName)
{
    GList *pList = m_pPixmapDirs;
    gchar *result = NULL;

    while (pList) {
        result = g_strdup_printf("%s%s%s", (gchar*)pList->data,
                                 G_DIR_SEPARATOR_S, pFileName);
        if (g_file_test(result, G_FILE_TEST_EXISTS)) {
            return result;
        }
        g_free(result);

        pList = pList->next;
    }

    return NULL;
}

/**
 * Pixmap, PixbufѤΥ꥽ǥ쥯ȥɲäޤ
 * 
 * @param pDir ꥽ǥ쥯ȥ
 */
void ResourceLoader::addPixmapDir(const char* pDir)
{
    m_pPixmapDirs = g_list_prepend(m_pPixmapDirs, g_strdup (pDir));
}
