/*
 * $Id: resourceloader.h,v 1.1 2004/04/01 08:52:58 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___RESOURCELOADER_H
#define ___RESOURCELOADER_H

#include "gtkmm.h"

class ResourceLoader {
public:
    /**
     * GtkImage ۤޤ
     * 
     * @param pFileName Pixmapե̾ 
     * @return ۤGtkImage
     */
    static Gtk::Image* createImage(const char* pFileName);
    
    /**
     * GdkPixbuf ۤޤ
     * 
     * @param pFileName Pixbufե̾
     * @return ۤGdkPixbuf
     */
    static Glib::RefPtr<Gdk::Pixbuf> createPixbuf(const char* pFileName);

public:
    /**
     * Pixmap, PixbufѤΥ꥽ǥ쥯ȥɲäޤ
     * 
     * @param pDir ꥽ǥ쥯ȥ
     */
    static void addPixmapDir(const char* pDir);

protected:
    /**
     * Pixmapե꥽ǥ쥯ȥõޤ
     * 
     * @param pFileName Pixmapե̾
     * @return ȯPixmapեΥѥ
     */
    static const char* findPixmapFile(const char* pFileName);

private:
    /**
     * PixmapѤΥ꥽ǥ쥯ȥ
     */
    static GList* m_pPixmapDirs;
};

#endif
