/*
 * $Id: tools.cpp,v 1.1 2004/04/01 08:52:58 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"

#include <iconv.h>

static char *_temp_name(const char *pBaseDir, const char *pPrefix);

/**
 * 桼Υۡǥ쥯ȥؤΥѥޤ
 *
 * @return 桼Υۡǥ쥯ȥؤΥѥ
 *         ѥβ/ϤʤǤ
 */
const char* getHomeDir()
{
    char *homedir = getenv("HOME");

    if (!homedir || 0 > strlen(homedir)) {
#ifdef DEBUG
        fprintf(stderr, "%s: can't get home directory by getenv().\n",
                APP_NAME);
#endif
        return NULL;
    }

    return homedir;
}

/**
 * ץꥱѤΥǥ쥯ȥؤΥѥޤ
 *
 * @param pAppName ץꥱ̾ꤷޤ(NULL Terminated)
 * @return ץꥱѤΥǥ쥯ȥؤΥѥ
 *         ǥ쥯ȥ̾νü pAppName νüƱǤ
 *         ѥβ/ϤʤǤ
 */
const char* getAppDir(const char *pAppName)
{
    static char buf[PATH_MAX +1];
    const char *pHome = getHomeDir();

    if (pHome) {
        memset(buf, '\0', sizeof(buf));

        strncpy(buf, pHome, sizeof(buf) -1);
        strncat(buf, "/.", sizeof(buf) -1);
        strncat(buf, pAppName, sizeof(buf) -1);

        return buf;
    }

    return NULL;
}

/**
 * 䵻ѤΥǥ쥯ȥ꤬¸ߤʤϡ˹ۤޤ
 */
void createFusenshiDir()
{
    const char *pDirPath = NULL;
    struct stat hdir;

    // ǥ쥯ȥ̾
    pDirPath = getAppDir(APP_NAME);

    // fusenshiѤǥ쥯ȥ̵ͭǧ
    if (pDirPath && 0 > stat(pDirPath, &hdir)) {
        // ǥ쥯ȥ
        mkdir(pDirPath, 0700);
    }
}

/**
 * 䵻ե̾ޤ
 *
 * @return 䵻եΥե̾
 *         եιۤϹԤޤ
 *         פˤʤäߥ󥰤 free() Ƥ
 */
char* createNewFusenshiFileName()
{
    const char *pDirPath = NULL;
    char *pResult = NULL;

    // åɥѤƱ
    static GStaticMutex mutex = G_STATIC_MUTEX_INIT;
    g_static_mutex_lock(&mutex);

    // ǥ쥯ȥ̾
    pDirPath = getAppDir(APP_NAME);

    if (pDirPath) {
        // fusenshiѤǥ쥯ȥ̵ͭǧ
        createFusenshiDir();

        // ζǡե̾
        pResult = _temp_name(pDirPath, "fusenshi.");
    }

    // åɥѤƱ
    g_static_mutex_unlock(&mutex);

    // ζǡե̾
    return pResult;
}

/**
 * ե̾ޤ
 *
 * @param ǥ쥯ȥѥ
 * @param ĥ
 * @return ե̾פˤʤäߥ󥰤 free() Ƥ
 */
static char *_temp_name(const char *pBaseDir, const char *pPrefix)
{
    int count = 0;
    int length = strlen(pBaseDir);
    char *pTemp = NULL;
    char *pResult = NULL;
    char *pDir = (char *)malloc(length +2);
    struct stat hstat;

    if (0 >= length) {
        return NULL;
    }
    
    if (!pDir) {
       return NULL;
    }
    
    strcpy(pDir, pBaseDir);

    if (pDir[length -1] != '/') {
        strcat(pDir, "/");
    }

    pTemp = (char *)malloc(strlen(pDir) + strlen(pPrefix) + 10);
    pResult = (char *)malloc(strlen(pDir) + strlen(pPrefix) + 10);

    if (!pTemp || !pResult) {
        free(pDir);
        if (pTemp) free(pTemp);
        if (pResult) free(pResult);
        return NULL;
    }

    strcpy(pTemp, pDir);
    strcat(pTemp, pPrefix);

    for (count = 1; MAX_FUSENSHI_NUM >= count; count++) {
        sprintf(pResult, "%s%d", pTemp, count);

        if (0 > stat(pResult, &hstat)) {
            break;
        }
    }

    if (MAX_FUSENSHI_NUM < count) {
        free(pResult);
        pResult = NULL;
    }
    
    free(pTemp);
    free(pDir);

    return pResult;
}

/**
 * ʸζޤ
 * 
 * @param szSrc ʸ
 * @return ζʸ
 */
Glib::ustring strTrim(Glib::ustring& szSrc)
{
    Glib::ustring str = strTrimLeft(szSrc);

    return strTrimRight(str);
}

/**
 * ʸζޤ
 * 
 * @param szSrc ʸ
 * @return ζʸ
 */
Glib::ustring strTrimLeft(Glib::ustring& szSrc)
{
    size_t firstPos = szSrc.find_first_not_of(" \t\r\n");
    size_t length = szSrc.length();

    if (0 > firstPos) firstPos = 0;
    else if (length < firstPos) firstPos = length;

    return szSrc.substr(firstPos);
}

/**
 * ʸθζޤ
 * 
 * @param szSrc ʸ
 * @return ζʸ
 */
Glib::ustring strTrimRight(Glib::ustring& szSrc)
{
    size_t lastPos = szSrc.find_last_not_of(" \t\r\n");
    size_t length = szSrc.length();

    if (0 > lastPos) lastPos = length;
    else if (length <= lastPos) lastPos = length -1;

    return szSrc.substr(0, lastPos +1);
}

/**
 * IPɥ쥹ʸɽޤ
 * 
 * @param nAddr IPɥ쥹
 * @return IPɥ쥹ʸɽ
 */
Glib::ustring IP2STR(long nAddr)
{
    typedef union _ADDR {
        long nAddr;
        struct {
           unsigned char b1;
           unsigned char b2;
           unsigned char b3;
           unsigned char b4;
        } byte;
    } ADDR;
    
    ADDR addr = {nAddr};
    Glib::ustring result;
    gchar buf[32];

    memset(buf, '\0', sizeof(buf));
    snprintf(buf, sizeof(buf) -1, "%d.%d.%d.%d",
        addr.byte.b1, addr.byte.b2,
        addr.byte.b3, addr.byte.b4);

    result = buf;
    
    return result;
}

/**
 * ʸ󤫤鿧ꤷޤ
 * 
 * @param pColor GdkColor¤
 * @param pValue ݻʸ
 * @return  true ᤹
 */
bool parseColor(GdkColor *pColor, const char *pValue)
{
    char *dummy = NULL;
    long nColor = 0L;
    
    if (!pColor || !pValue) {
        throw "Null Pointer Exception.";
    }

    if (gdk_color_parse(pValue, pColor)) {
        return true;
    }
    else {
        if (6 == strlen(pValue)) {
            nColor = strtol(pValue, &dummy, 16);
            
            if (dummy && '\0' == *dummy) {
                pColor->red   = (nColor & 0xff0000) >> 8;
                pColor->green = (nColor & 0x00ff00);
                pColor->blue  = (nColor & 0x0000ff) << 8;
                
                return true;
            }
        }
    }
    
    return false;
}

/**
 * ɽʸޤ
 * 
 * @param pColor GdkColor¤
 * @param szBuffer ʸǼХåե
 */
void toString(const GdkColor *pColor, Glib::ustring& szBuffer)
{
    char buf[10] = {0};

    snprintf(buf, sizeof(buf) -1, "%02x%02x%02x",
             (pColor->red & 0xff00) >> 8,
             (pColor->green & 0xff00) >> 8,
             (pColor->blue & 0xff00) >> 8);
    
    szBuffer = buf;
}
