/*
 * $Id: fusenshiclient.cpp,v 1.1 2004/04/01 08:53:12 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshiclient.h"
#include "../include/propertydata.h"

#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef _SC_HOST_NAME_MAX
const long _HOST_NAME_MAX = sysconf(_SC_HOST_NAME_MAX);
#endif

/**
 * 󥹥ȥ饯
 */
FusenshiClient::FusenshiClient()
{
}

/**
 * ǥȥ饯
 */
FusenshiClient::~FusenshiClient()
{
}

/**
 * 䵻ǡޤ
 * 
 * @param pIP IP
 * @param pData 䵻ǡ
 */
bool FusenshiClient::sendFusenshiData
    (const gchar* pIP, const GString* pData,
     const Glib::ustring& szNickName)
{
    int sock = 0;
    struct sockaddr_in saddr;

    if (!pData || MAX_FUSENSHIDATA_LENGTH < pData->len) {
        fprintf(stderr, "%s: data is too long.\n", APP_NAME);
        return false;
    }

    // ³
    memset(&saddr, 0, sizeof(saddr));
    saddr.sin_port = htons(FUSENSHI_PORT);
    saddr.sin_family = PF_INET;
    saddr.sin_addr.s_addr = inet_addr(pIP);

    if (INADDR_NONE == saddr.sin_addr.s_addr) {
        return false;
    }

    // åȤ򳫤
    sock = socket(PF_INET, SOCK_STREAM, 0);

    if (-1 == sock) {
        return false;
    }
    
    // åȥץ
    int optval = 1;
    struct timeval opttout = { 10, 0 }; // 10 sec
    setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval));
    setsockopt(sock, SOL_SOCKET, SO_SNDTIMEO, &opttout, sizeof(opttout));
    setsockopt(sock, SOL_SOCKET, SO_RCVTIMEO, &opttout, sizeof(opttout));

    // ³
    if (connect(sock, (struct sockaddr *)&saddr, sizeof(saddr))) {
        close(sock);
        return false;
    }
    
    // 
    gint length;
    gchar buf[MAX_EXT_INFO_LENGTH];
    gchar szHostName[_HOST_NAME_MAX +1];
    
    // ۥ̾
    memset(szHostName, 0, sizeof(szHostName));
    if (gethostname(szHostName, sizeof(szHostName) -1)) {
        strncpy(szHostName, "unknown", sizeof(szHostName) -1);
    }

    // 桼ۥȾ
    memset(buf, '\0', sizeof(buf));
    snprintf(buf, sizeof(buf) -1, "%s|%s",
        szNickName.c_str(), szHostName);
    length = htonl(strlen(buf) +1);

    if (sizeof(length) != send(sock, &length, sizeof(length), 0)) {
        close(sock);
        return false;
    }

    length = ntohl(length);
    if (length != send(sock, buf, length, 0)) {
        close(sock);
        return false;
    }
    
    // 䵻ǡ
    length = htonl(pData->len);

    if (sizeof(length) != send(sock, &length, sizeof(length), 0)) {
        close(sock);
        return false;
    }

    length = pData->len;
    if (length != send(sock, pData->str, length, 0)) {
        close(sock);
        return false;
    }
    
    close(sock);

    return true;
}

/**
 * 䵻ǡޤ
 * 
 * @param netInfo 
 * @param data 䵻ǡ
 */
bool FusenshiClient::sendFusenshiData
    (ServerList& serverList, const FusenshiData& data,
     const Glib::ustring& szNickName)
{
    bool result = true;
    
    serverList.lockList();

    std::list<Glib::ustring>& ipList = serverList.getIPAddrList();
    std::list<Glib::ustring>::iterator iter;

    GString* pData = FusenshiData::toSerializedString(&data);
    
    for (iter = ipList.begin(); iter != ipList.end(); iter++) {
        result &= sendFusenshiData((*iter).c_str(), pData, szNickName);
    }
    
    g_string_free(pData, TRUE);
    
    serverList.unlockList();
    
    return result;
}

/**
* 䵻楯饤Ȥ¸߳ǧѥ֥ɥ㥹ȥѥåȤ
* Фޤ
*/
void FusenshiClient::sendServerInfoRequest(const PropertyData& property)
{
    int sock = 0;
    struct sockaddr_in taddr;
    
    BroadcastList& list = (BroadcastList&)property.getBroadcastList();
    BroadcastList::iterator iter = list.begin();
    
    for (; iter != list.end(); iter++) {
        memset(&taddr, 0, sizeof(taddr));
        taddr.sin_family = PF_INET;
        taddr.sin_port = htons(FUSENSHI_PORT);
        taddr.sin_addr.s_addr = inet_addr((*iter).c_str());

        sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);

        if (-1 != sock) {
            int optval = 1;

            if (!setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &optval, sizeof(optval))) {
                char buf[3] = {
                    FNET_CMD_REQUEST,
                    FUSENSHI_NET_PROTO_MAJOR_VERSION,
                    FUSENSHI_NET_PROTO_MINOR_VERSION
                };

                sendto(sock, buf, sizeof(buf), 0,
                    (struct sockaddr *)&taddr, sizeof(taddr));
            }

            close(sock);
        }
    }
}
