/*
 * $Id: fusenshiserver.cpp,v 1.1 2004/04/01 08:53:12 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshiserver.h"

#include "gtkmm.h"

#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

static int receiveCheck(int nSock, struct sockaddr_in* pCAddr);
static bool receiveClientInfo
    (int nCSock, Glib::ustring& szUser, Glib::ustring& szHost);
static GString* receiveData(int nCSock);

/**
 * ͣΥ󥹥
 */
FusenshiServer* FusenshiServer::m_pInstance = NULL;

/**
 * 󥹥ȥ饯
 */
FusenshiServer::FusenshiServer()
{
    // ХåȤι
    m_nSocket = socket(PF_INET, SOCK_STREAM, 0);

    if (-1 == m_nSocket) {
        throw "socket() failed.";
    }
    
    int optval = 1;
    struct sockaddr_in saddr;

    memset(&saddr, 0, sizeof(saddr));
    saddr.sin_port = htons(FUSENSHI_PORT);
    saddr.sin_family = PF_INET;
    saddr.sin_addr.s_addr = htonl(INADDR_ANY);

    if (setsockopt(m_nSocket, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval))) {
        m_nSocket = -1;
        throw "setsockopt() failed.";
    }

    if (bind(m_nSocket, (struct sockaddr *)&saddr, sizeof(saddr))) {
        close(m_nSocket);
        m_nSocket = -1;
        
        throw "bind() failed.";
    }
    else {
        listen(m_nSocket, 5);
    }
}

/**
 * ǥȥ饯
 */
FusenshiServer::~FusenshiServer()
{
    if (0 <= m_nSocket) {
        close(m_nSocket);
        m_nSocket = -1;
    }
}

/**
 * ǡ̵ͭǧǡ¸ߤ
 * 򳫻Ϥޤ
 * 
 * @return 䵻ǡ
 *         ʤä NULL ᤷޤ
 */
GString* FusenshiServer::checkAndReceive()
{
    if (-1 == m_nSocket) {
        return NULL;
    }
    
    GString* result = NULL;
    
    int nCSock = -1;
    struct sockaddr_in cAddr;
    
    nCSock = receiveCheck(m_nSocket, &cAddr);
    
    if (-1 != nCSock) {
        Glib::ustring szUser;
        Glib::ustring szHost;
        Glib::ustring szIP;
        
        if (receiveClientInfo(nCSock, szUser, szHost)) {
            result = receiveData(nCSock);
        }
        
        close(nCSock);

        if (result) {
            szIP = IP2STR(cAddr.sin_addr.s_addr);

            // 桼̾
            g_string_prepend(result, (szUser + "\r\n").c_str());
            g_string_prepend(result, NET_CLIENT_USER ": ");

            // ۥ̾
            g_string_prepend(result, (szHost + "\r\n").c_str());
            g_string_prepend(result, NET_CLIENT_HOST ": ");

            // IPɥ쥹
            g_string_prepend(result, (szIP + "\r\n").c_str());
            g_string_prepend(result, NET_CLIENT_IP ": ");
        }
    }
    
    return result;
}

/**
 * ͣΥ󥹥󥹤ޤ
 * 
 * @return ͣΥ󥹥
 */
FusenshiServer* FusenshiServer::getInstance()
{
    if (NULL == m_pInstance) {
        try {
            m_pInstance = new FusenshiServer();
        }
        catch (const char* pErrorMsg) {
            fprintf(stderr, "%s: Server: %s\n", APP_NAME, pErrorMsg);
        }
        catch (...) {
            fprintf(stderr, "%s: Server: Unknown Error.\n", APP_NAME);
        }
    }
    
    return m_pInstance;
}

/**
 * ХåȤץꥱλνԤޤ
 */
void FusenshiServer::destroy()
{
    if (m_pInstance) {
        delete m_pInstance;
        m_pInstance = NULL;
    }
}

/**
 * 䵻μ׵Ĵ١׵᤬ϥ饤ȥåȤ
 * ޤ
 * 
 * @param nSock Хå
 * @param pCAddr 饤ȾǼΰ
 * @return 饤ȥå
 */
int receiveCheck(int nSock, struct sockaddr_in* pCAddr)
{
    int result = -1;

    fd_set rfds;
    struct timeval timeout = {0, 10 * 1000 /* 10ms */};

    FD_ZERO(&rfds);
    FD_SET(nSock, &rfds);

    if (0 < select(nSock +1, &rfds, NULL, NULL, &timeout)) {
        socklen_t addrsize = sizeof(*pCAddr);

        result = accept(nSock, (struct sockaddr *)pCAddr, &addrsize);
    }

    return result;
}

/**
 * 饤Ȥξޤ
 * 
 * @param nCSock 饤ȤȤ³å
 * @param strUser 桼̾Ǽΰ
 * @param strHost ۥ̾Ǽΰ
 * @return  true ᤷޤ
 */
bool receiveClientInfo
    (int nCSock, Glib::ustring& szUser, Glib::ustring& szHost)
{
    gint length = 0;
    gchar* buf = NULL;
    
    // 桼ۥȾ
    if (sizeof(length) != recv(nCSock, &length, sizeof(length), 0)) {
        return false;
    }

    length = ntohl(length);
    if (2 >= length && MAX_EXT_INFO_LENGTH < length) {
        return false;
    }

    buf = (gchar*)g_malloc0(length);
    
    if (!buf) {
        fprintf(stderr, "%s: Out of Memory Error!\n", APP_NAME);
        return false;
    }
    
    if (length != recv(nCSock, buf, length, 0) ||
        buf[length] != '\0') {
        g_free(buf);
        return false;
    }
    
    gchar* pTmp = strchr(buf, '|');
    
    if (!pTmp) {
       g_free(buf);
       return false;
    }
    
    *pTmp = '\0';
    szUser = buf;
    szHost = ++pTmp;
    
    g_free(buf);
    
    return true;
}

/**
 * 䵻ǡޤ
 * 
 * @param nCSock 饤ȤȤ³å
 * @return 䵻ǡ
 */
GString* receiveData(int nCSock)
{
    GString* result = NULL;
    gchar* buffer = NULL;
    
    gint length = 0;

    // ե
    if (sizeof(length) != recv(nCSock, &length, sizeof(length), 0)) {
        return NULL;
    }

    length = ntohl(length);
    if (MAX_FUSENSHIDATA_LENGTH < length || 0 >= length) {
        return NULL;
    }
    
    buffer = (gchar*)g_malloc0(length +1);
    if (!buffer) {
        fprintf(stderr, "%s: Out of Memory Error!\n", APP_NAME);
        return NULL;
    }
    
    if (length != recv(nCSock, buffer, length, 0)) {
        g_free(buffer);
        return NULL;
    }
    
    result = g_string_new(buffer);
    g_free(buffer);
    
    return result;
}
