/*
 * $Id: fusenshiserverinfo.cpp,v 1.1 2004/04/01 08:53:12 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshiserverinfo.h"

#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

static gpointer serverInfoProcessThread(gpointer data);

/**
 * ХؿȤƱѥߥ塼ƥå
 */
static GMutex* g_pMutex = NULL;

/**
 * åߥե饰
 */
static int g_bStop = FALSE;

/**
 * ͣΥ󥹥
 */
FusenshiServerInfo* FusenshiServerInfo::m_pInstance = NULL;

/**
 * 󥹥ȥ饯
 */
FusenshiServerInfo::FusenshiServerInfo()
{
    // gthread ν    
    if (!g_thread_supported()) g_thread_init(NULL);

    g_pMutex = g_mutex_new();
    
    if (!g_pMutex) {
        throw "Can't create mutex.";
    }
    
    // ֥ɥ㥹䤤碌˱륹åɤι
    g_bStop = FALSE;
    m_pThread =
        g_thread_create(serverInfoProcessThread, this, TRUE, NULL);

    if (!m_pThread) {
        fprintf(stderr, "%s: Can't create broadcast process thread.\n", APP_NAME);
    }
}

/**
 * ǥȥ饯
 */
FusenshiServerInfo::~FusenshiServerInfo()
{
    if (m_pThread) {
        g_mutex_lock(g_pMutex);
        g_bStop = TRUE;
        g_mutex_unlock(g_pMutex);
        
        g_thread_join(m_pThread);
        m_pThread = NULL;
    }
    
    if (g_pMutex) {
        g_mutex_free(g_pMutex);
    }
}

/**
 * 䵻極Фΰޤ
 * 
 * @return 䵻極Фΰ
 */
ServerList& FusenshiServerInfo::getServerList()
{
    return m_cServerList;
}

/**
 * ˥å͡ޤ
 * 
 * @return ˥å͡
 */
Glib::ustring FusenshiServerInfo::getNickName() const
{
    Glib::ustring result;

    g_mutex_lock(g_pMutex);
    result = m_szNickName;
    g_mutex_unlock(g_pMutex);
    
    return result;
}

/**
 * ˥å͡ꤷޤ
 * 
 * @param szNickName ˥å͡
 */
void FusenshiServerInfo::setNickName(const Glib::ustring szNickName)
{
    g_mutex_lock(g_pMutex);
    m_szNickName = szNickName;
    g_mutex_unlock(g_pMutex);
}

/**
 * ͣΥ󥹥󥹤ޤ
 */
FusenshiServerInfo* FusenshiServerInfo::getInstance()
{
    if (!m_pInstance) {
        try {
            m_pInstance = new FusenshiServerInfo();
        }
        catch (const char* pErrorMsg) {
            fprintf(stderr, "%s: FusenshiServerInfo: %s\n", APP_NAME, pErrorMsg);
            m_pInstance = NULL;
        }
        catch (...) {
            fprintf(stderr, "%s: FusenshiServerInfo: unknown error.\n", APP_NAME);
            m_pInstance = NULL;
        }
    }
    
    return m_pInstance;
}

/**
 * ꥯȱåɤλץꥱλνԤޤ
 */
void FusenshiServerInfo::destroy()
{
    if (m_pInstance) {
        delete m_pInstance;
        m_pInstance = NULL;
    }
}

/**
 *  ֥ɥ㥹䤤碌ޤ
 */
gpointer serverInfoProcessThread(gpointer data)
{
    FusenshiServerInfo *pSrvInfo = (FusenshiServerInfo*)data;
    
    if (!pSrvInfo) {
        fprintf(stderr, "%s: Null Pointer Exception.\n", APP_NAME);
        return 0;
    }

    ServerList& serverList = pSrvInfo->getServerList();
    
    // ХåȤι
    int sock = -1;
    struct sockaddr_in saddr;

    fd_set rfds;
    struct timeval timeout = {0, 25 * 1000 /* 25 ms */};

    memset(&saddr, 0, sizeof(saddr));
    saddr.sin_port = htons(FUSENSHI_PORT);
    saddr.sin_family = PF_INET;
    saddr.sin_addr.s_addr = htonl(INADDR_ANY);

    sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);

    if (-1 == sock) {
        fprintf(stderr, "%s: Can't create UDP socket.\n", APP_NAME);
        return 0;
    }
    
    int optval = 1;

    if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &optval, sizeof(optval)) ||
        setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(optval))) {
        close(sock);
        fprintf(stderr, "%s: Can't set option to socket.\n", APP_NAME);
        return 0;
    }

    if (bind(sock, (struct sockaddr *)&saddr, sizeof(saddr))) {
        close(sock);
        fprintf(stderr, "%s: bind() failed.\n", APP_NAME);
        return 0;
    }

    // ν
    int nRecv = 0;
    char buf[513]; // UDP packet size +1
    char *pTmp = NULL;

    struct sockaddr_in caddr;
    socklen_t caddrlen = 0;
    
    gchar szHostName[_HOST_NAME_MAX +1];
    
    // ۥ̾
    memset(szHostName, 0, sizeof(szHostName));
    if (gethostname(szHostName, sizeof(szHostName) -1)) {
        strncpy(szHostName, "unknown", sizeof(szHostName) -1);
    }

    int bStop = FALSE;

    // γ
    while (!bStop) {
        FD_ZERO(&rfds);
        FD_SET(sock, &rfds);

        if (0 < select(sock +1, &rfds, NULL, NULL, &timeout)) {
            caddrlen = sizeof(caddr);
            memset(&caddr, 0, sizeof(caddr));

            memset(buf, '\0', sizeof(buf));
            nRecv = recvfrom(sock, buf, sizeof(buf) -1, 0,
                             (struct sockaddr *)&caddr, &caddrlen);

            if (3 > nRecv) {
                continue;
            }

            if (FUSENSHI_NET_PROTO_MAJOR_VERSION != buf[1] ||
                FUSENSHI_NET_PROTO_MINOR_VERSION != buf[2]) {
                continue;
            }

            switch (buf[0]) {
            case FNET_CMD_REQUEST:
                memset(buf, '\0', sizeof(buf));
                snprintf(buf +3, sizeof(buf) -4, "%s|%s",
                         pSrvInfo->getNickName().c_str(), szHostName);

                buf[0] = FNET_CMD_RESPONSE;
                buf[1] = FUSENSHI_NET_PROTO_MAJOR_VERSION;
                buf[2] = FUSENSHI_NET_PROTO_MINOR_VERSION;

                caddr.sin_port = htons(FUSENSHI_PORT);

                // о
                sendto(sock, buf, strlen(buf +3) +3, 0,
                       (struct sockaddr *)&caddr, sizeof(caddr));
                break;
            case FNET_CMD_RESPONSE:
                pTmp = strchr(buf +3, '|');

                if (pTmp) {
                    *pTmp = '\0';
                    
                    // аɲ
                    serverList.add
                        (buf +3, pTmp +1, IP2STR(caddr.sin_addr.s_addr));
                }
                break;
            default:
                fprintf(stderr, "%s: Unknown command received. (%d)\n",
                        APP_NAME, buf[0]);
                break;
            }
        }
        
        // λե饰μ
        g_mutex_lock(g_pMutex);
        bStop = g_bStop;
        g_mutex_unlock(g_pMutex);
    }

    close(sock);

    return 0;
}
