/*
 * $Id: networkfusenshidata.cpp,v 1.1 2004/04/01 08:53:12 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "../include/networkfusenshidata.h"

/**
 * 󥹥ȥ饯
 */
NetworkFusenshiData::NetworkFusenshiData()
{
    m_szUserName.clear();
    m_szHostName.clear();
    m_szIPAddr.clear();
}

/**
 * ǥȥ饯
 */
NetworkFusenshiData::~NetworkFusenshiData()
{
}

/**
 * 桼̾ޤ
 * 
 * @return 桼̾
 */
Glib::ustring NetworkFusenshiData::getUserName() const
{
    return m_szUserName;
}

/**
 * ۥ̾ޤ
 * 
 * @return ۥ̾
 */
Glib::ustring NetworkFusenshiData::getHostName() const
{
    return m_szHostName;
}

/**
 * IPɥ쥹ޤ
 * 
 * @return IPɥ쥹
 */
Glib::ustring NetworkFusenshiData::getIPAddr() const
{
    return m_szIPAddr;
}

/**
 * 桼̾ޤ
 * 
 * @param szUserName 桼̾
 */
void NetworkFusenshiData::setUserName(Glib::ustring szUserName)
{
    m_szUserName = szUserName;
}

/**
 * ۥ̾ޤ
 * 
 * @param szHostName ۥ̾
 */
void NetworkFusenshiData::setHostName(Glib::ustring szHostName)
{
    m_szHostName = szHostName;
}

/**
 * IPɥ쥹ޤ
 * 
 * @param szIPAddr IPɥ쥹
 */
void NetworkFusenshiData::setIPAddr(Glib::ustring szIPAddr)
{
    m_szIPAddr = szIPAddr;
}

/**
 * ꥢ饤줿䵻ǡ䵻ǡ֥Ȥ
 * ۤޤ
 * 
 * @param pData ꥢ饤ΥХ
 * @return 䵻ǡ֥ȡ
 *         פˤʤäʳ˴ɬפޤ
 */
FusenshiData* NetworkFusenshiData::buildObject
    (const GString* pBytes)
{
    NetworkFusenshiData* result = new NetworkFusenshiData();
    
    if (!result) {
        throw "Out of Memory Error!";
    }

    try {
        result->buildObjectCore(pBytes);
    }
    catch (const char* pErrorMsg) {
        delete result;
        result = NULL;
        throw pErrorMsg;
    }
    catch (...) {
        delete result;
        result = NULL;
        fprintf(stderr, "%s: Unknown Error!\n", APP_NAME);
    }
    
    return result;
}

/**
 * 䵻ǡ֥Ȥ򥷥ꥢ饤ޤ
 * 
 * @param pData 䵻ǡ֥
 * @return ꥢ饤ΥХ
 *         פˤʤäʳ˴ɬפޤ
 */
/**
 * ߤμǤϻѤޤ
 * 
GString* NetworkFusenshiData::toSerializedString
    (const FusenshiData* pData, Glib::ustring szUserName, 
     Glib::ustring szHostName, Glib::ustring szIPAddr)
{
    GString* result = FusenshiData::toSerializedString(pData);
    
    if (!result) {
        return result;
    }

    // 桼̾
    g_string_prepend(result, "\r\n");
    g_string_prepend(result, szUserName.c_str());
    g_string_prepend(result, NET_CLIENT_USER ": ");

    // ۥ̾
    g_string_prepend(result, "\r\n");
    g_string_prepend(result, szHostName.c_str());
    g_string_prepend(result, NET_CLIENT_HOST ": ");

    // IPɥ쥹
    g_string_prepend(result, "\r\n");
    g_string_prepend(result, szIPAddr.c_str());
    g_string_prepend(result, NET_CLIENT_IP ": ");

    return result;
}
*/

/**
 * 䵻ǡ֥Ȥ򥷥ꥢ饤ޤ
 * 
 * @param pData 䵻ǡ֥
 * @return ꥢ饤ΥХ
 *         פˤʤäʳ˴ɬפޤ
 */
/**
 * ߤμǤϻѤޤ
 * 
GString* NetworkFusenshiData::toSerializedString
    (const FusenshiData* pData)
{
    return toSerializedString(pData, "", "", "");
}
*/

/**
 * ꥢ饤줿䵻ǡκǾñ̤ϡꤷޤ
 * 
 * @param szType ǡ
 * @param szValue ǡ
 */
void NetworkFusenshiData::parseValueAndSet
    (Glib::ustring& szType, Glib::ustring& szValue)
{
    FusenshiData::parseValueAndSet(szType, szValue);

    // 桼̾
    if (strcasecmp(szType.c_str(), NET_CLIENT_USER) == 0) {
        setUserName(szValue);
    }
    // ۥ̾
    else if (strcasecmp(szType.c_str(), NET_CLIENT_HOST) == 0) {
        setHostName(szValue);
    }
    // IPɥ쥹
    else if (strcasecmp(szType.c_str(), NET_CLIENT_IP) == 0) {
        setIPAddr(szValue);
    }
}
