/*
 * $Id: serverlist.cpp,v 1.1 2004/04/01 08:53:12 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "../include/serverlist.h"

/**
 * 󥹥ȥ饯
 */
ServerList::ServerList()
{
}

/**
 * ǥȥ饯
 */
ServerList::~ServerList()
{
}

/**
 * ˥оɲäޤ
 * 
 * @param pUserName 桼̾
 * @param pHostName ۥ̾
 * @param pIPAddr IPɥ쥹
 */
void ServerList::add
    (Glib::ustring szUserName, Glib::ustring szHostName,
     Glib::ustring szIPAddr)
{
    lockList();
    
    // Ʊ̵ͭå
    std::list<Glib::ustring>::iterator iter;
    
    for (iter = m_cIPAddr.begin(); iter != m_cIPAddr.end(); iter++) {
        if (*iter == szIPAddr) {
            break;
        }
    }
    
    if (iter == m_cIPAddr.end()) {
        m_cUserName.push_back(szUserName.c_str());
        m_cHostName.push_back(szHostName.c_str());
        m_cIPAddr.push_back(szIPAddr.c_str());
    }
    
    unlockList();
}

/**
 * ޤ
 */
void ServerList::clear()
{
    lockList();
    m_cUserName.clear();
    m_cHostName.clear();
    m_cIPAddr.clear();
    unlockList();
}

/**
 * 桼̾ΰޤ
 */
std::list<Glib::ustring>& ServerList::getUserNameList()
{
    return m_cUserName;
}

/**
 * ۥ̾ΰޤ
 */
std::list<Glib::ustring>& ServerList::getHostNameList()
{
    return m_cHostName;
}

/**
 * IPɥ쥹ΰޤ
 */
std::list<Glib::ustring>& ServerList::getIPAddrList()
{
    return m_cIPAddr;
}

/**
 * ιߤޤ
 */
void ServerList::lockList()
{
    m_cMutex.lock();
}

/**
 * ιΰߤޤ
 */
void ServerList::unlockList()
{
    m_cMutex.unlock();
}
