/*
 * $Id: entrydialog.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "entrydialog.h"

/**
 * 󥹥ȥ饯
 */
EntryDialog::EntryDialog(Glib::ustring szTitle)
{
    set_wmclass(APP_NAME, "EntryDialog");
    set_title(szTitle.c_str());
    set_modal(true);
    set_default_size(300, 150);
    property_destroy_with_parent() = true;
    
    Gtk::Fixed *pFixed = manage(new Gtk::Fixed());
    pFixed->put(m_cEntry, 10, 25);
    
    m_cEntry.set_size_request(250, 20);
    
    pFixed->put(m_cEntryLabel, 10, 5);
    m_cEntryLabel.set_alignment(0.0, 0.5);
    m_cEntryLabel.set_size_request(250, 16);
    m_cEntryLabel.set_justify(Gtk::JUSTIFY_LEFT);
    
    pFixed->put(m_cMessageLabel, 10, 50);
    m_cMessageLabel.set_alignment(0.0, 0.5);
    m_cMessageLabel.set_size_request(250, 16);
    m_cMessageLabel.set_justify(Gtk::JUSTIFY_LEFT);
    m_cMessageLabel.set_line_wrap(true);
    
    get_vbox()->pack_start(*pFixed, true, true, 0);
    get_action_area()->set_layout(Gtk::BUTTONBOX_END);

    Gtk::Button* pButton = manage(new Gtk::Button(Gtk::StockID("gtk-cancel")));
    add_action_widget(*pButton, Gtk::RESPONSE_CANCEL);
    //pButton->set_flags(Gtk::CAN_DEFAULT);

    pButton = manage(new Gtk::Button(Gtk::StockID("gtk-ok")));
    add_action_widget(*pButton, Gtk::RESPONSE_OK);
    pButton->set_flags(Gtk::CAN_DEFAULT);
    
    set_default_response(Gtk::RESPONSE_OK);
}

/**
 * ǥȥ饯
 */
EntryDialog::~EntryDialog()
{
}

/**
 * ⡼Ȥɽޤ
 * 
 * @return λɡ
 */
gint EntryDialog::doModal()
{
    show_all_children();
    
    return run();
}

/**
 * ȥ꡼Ϥ줿ʸޤ
 * 
 * @return ȥ꡼Ϥ줿ʸ
 */
Glib::ustring EntryDialog::getText()
{
    return m_cEntry.get_text();
}

/**
 * ȥ꡼ʸꤷޤ
 * 
 * @param szText ȥ꡼ꤹʸ
 */
void EntryDialog::setText(Glib::ustring szText)
{
    m_cEntry.set_text(szText);
}

/**
 * ȥ꡼ѤΥ٥ʸꤷޤ
 * 
 * @param szText ٥ꤹʸ
 */
void EntryDialog::setEntryLabel(Glib::ustring szText)
{
    m_cEntryLabel.set_text(szText);
}

/**
 * åѤΥ٥ʸꤷޤ
 * 
 * @param szText ٥ꤹʸ
 */
void EntryDialog::setMessageLabel(Glib::ustring szText)
{
    m_cMessageLabel.set_text(szText);
}
