/*
 * $Id: fusenshieditdialog.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshieditdialog.h"

/**
 * 󥹥ȥ饯
 */
FusenshiEditDialog::FusenshiEditDialog(const FusenshiData* pData)
{
    if (!pData) {
        throw "Null Pointer Exception.";
    }
    
    m_pOriginalData = pData;
    m_cData = *pData;
    
    set_wmclass(APP_NAME, "FusenshiEdit");
    set_title(_("Fusenshi - Edit"));
    set_modal(true);
    //set_position(Gtk::WIN_POS_CENTER);
    set_default_size(400, 300);
    property_destroy_with_parent() = true;

    Gtk::Notebook* pNotebook = manage(new Gtk::Notebook());
    get_vbox()->pack_start(*pNotebook, true, true, 0);

    Gtk::ScrolledWindow* pScrolledWnd = manage(new Gtk::ScrolledWindow());
    pScrolledWnd->set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
    pNotebook->add(*pScrolledWnd);

    m_cTextView.set_left_margin(5);
    m_cTextView.set_right_margin(5);
    pScrolledWnd->add(m_cTextView);

    Gtk::Fixed* pFixed = manage(new Gtk::Fixed());
    pNotebook->add(*pFixed);

    pNotebook->set_tab_label_text
        (*(pNotebook->get_nth_page(0)), _("Text"));
    pNotebook->set_tab_label_text
        (*(pNotebook->get_nth_page(1)), _("Property"));

    pFixed->put(m_cBackground, 10, 30);
    m_cBackground.set_size_request(200, 24);
    m_cBackground.set_max_length(20);

    pFixed->put(m_cForeground, 10, 80);
    m_cForeground.set_size_request(200, 24);
    m_cForeground.set_max_length(20);
    
    pFixed->put(m_cFontName, 10, 130);
    m_cFontName.set_size_request(200, 24);
    m_cFontName.set_max_length(256);

    Gtk::Label* pLabel =
        manage(new Gtk::Label(_("Background Color:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 10);
    pLabel->set_size_request(150, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    pLabel = manage(new Gtk::Label(_("Foreground Color:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 60);
    pLabel->set_size_request(150, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);

    pLabel = manage(new Gtk::Label(_("Font:"), 0.0, 0.5));
    pFixed->put(*pLabel, 10, 110);
    pLabel->set_size_request(150, 16);
    pLabel->set_justify(Gtk::JUSTIFY_LEFT);
    
    Gtk::Button* pBgButton = manage(new Gtk::Button(_("Select..."), true));
    pFixed->put(*pBgButton, 220, 30);
    pBgButton->set_size_request(60, 24);

    Gtk::Button* pFgButton = manage(new Gtk::Button(_("Select..."), true));
    pFixed->put(*pFgButton, 220, 80);
    pFgButton->set_size_request(60, 24);

    Gtk::Button* pFnButton = manage(new Gtk::Button(_("Select..."), true));
    pFixed->put(*pFnButton, 220, 130);
    pFnButton->set_size_request(60, 24);

    get_action_area()->set_layout(Gtk::BUTTONBOX_END);

    Gtk::Button* pButton = manage(new Gtk::Button(Gtk::StockID("gtk-cancel")));
    add_action_widget(*pButton, Gtk::RESPONSE_CANCEL);
    //pButton->set_flags(Gtk::CAN_DEFAULT);

    pButton = manage(new Gtk::Button(Gtk::StockID("gtk-ok")));
    add_action_widget(*pButton, Gtk::RESPONSE_OK);
    pButton->set_flags(Gtk::CAN_DEFAULT);

    set_default_response(Gtk::RESPONSE_OK);

    pBgButton->signal_clicked().connect
        (SigC::slot(*this, &FusenshiEditDialog::on_background_clicked));
    pFgButton->signal_clicked().connect
        (SigC::slot(*this, &FusenshiEditDialog::on_foreground_clicked));
    pFnButton->signal_clicked().connect
        (SigC::slot(*this, &FusenshiEditDialog::on_fontname_clicked));

    // ¸Υǡ
    gchar buf[1024] = {0};
    const guint bufsize = sizeof(buf) -1;

    memset(buf, '\0', sizeof(buf));
    
    // ץѥƥ
    Gdk::Color bgColor((GdkColor*)pData->getBackground());
    snprintf(buf, bufsize, "#%02X%02X%02X", 
             (int)rint(bgColor.get_red_p() * 0xff),
             (int)rint(bgColor.get_green_p() * 0xff),
             (int)rint(bgColor.get_blue_p() * 0xff));
    m_cBackground.set_text(buf);

    Gdk::Color fgColor((GdkColor*)pData->getForeground());
    snprintf(buf, bufsize, "#%02X%02X%02X", 
             (int)rint(fgColor.get_red_p() * 0xff),
             (int)rint(fgColor.get_green_p() * 0xff),
             (int)rint(fgColor.get_blue_p() * 0xff));
    m_cForeground.set_text(buf);
    
    m_cFontName.set_text(pData->getFontName());

    // ʿطʿ
    m_cTextView.modify_base(Gtk::STATE_NORMAL, bgColor);
    m_cTextView.modify_text(Gtk::STATE_NORMAL, fgColor);
    
    // եȤ
    Pango::FontDescription* pFont = 
        new Pango::FontDescription(pData->getFontName());
    m_cTextView.modify_font(*pFont);
    delete pFont;
    
    // ƥȤ
    Glib::RefPtr<Gtk::TextBuffer> textBuffer =
        m_cTextView.get_buffer();
    textBuffer->set_text(pData->getText());
}

/**
 * ǥȥ饯
 */
FusenshiEditDialog::~FusenshiEditDialog()
{
}

/**
 * ⡼Ȥɽޤ
 * 
 * @return λɡ
 */
gint FusenshiEditDialog::doModal()
{
    show_all_children();
    
    return run();
}

/**
 * 䵻ǡޤ
 * 
 * @return 䵻ǡ
 */
const FusenshiData& FusenshiEditDialog::getNewData()
{
    return m_cData;
}

/**
 * ǡѹ̵ͭåޤ
 * 
 * @return ѹ true ᤷޤ
 */
bool FusenshiEditDialog::isChanged()
{
    return (m_cData != *m_pOriginalData);
}

/**
 * ɥκ׵ޤ
 */
bool FusenshiEditDialog::on_delete_event(GdkEventAny* pEvent)
{
    on_response(Gtk::RESPONSE_CANCEL);
    
    return true;
}

/**
 * 쥹ݥ
 */
void FusenshiEditDialog::on_response(int nResponse)
{
    m_nResponse = nResponse;
    
    if (Gtk::RESPONSE_OK == nResponse) {
        // ͤΥå
        Gdk::Color bgColor;
        Gdk::Color fgColor;
        
        if (!bgColor.parse(m_cBackground.get_text())) {
            Gtk::MessageDialog msgdlg(_("Can't parse background color."),
                Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true, false);
                
            msgdlg.run();
            return;
        }
        if (!fgColor.parse(m_cForeground.get_text())) {
            Gtk::MessageDialog msgdlg(_("Can't parse foreground color."),
                Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true, false);
                
            msgdlg.run();
            return;
        }
        
        m_cData.setBackground(bgColor.gobj());
        m_cData.setForeground(fgColor.gobj());
        m_cData.setFontName(m_cFontName.get_text().c_str());
        m_cData.setText(m_cTextView.get_buffer()->get_text().c_str());
    }
    
    Gtk::Dialog::on_response(nResponse);
}

/**
 * طʿ
 */
void FusenshiEditDialog::on_background_clicked()
{
    Gtk::ColorSelectionDialog colordlg;
    
    colordlg.set_title(_("Background Color:"));
    colordlg.set_transient_for(*this);
    colordlg.get_help_button()->hide();

    Gdk::Color bgColor;
    bgColor.parse(m_cBackground.get_text());
    colordlg.get_colorsel()->set_current_color(bgColor);
    
    if (Gtk::RESPONSE_OK == colordlg.run()) {
        Gdk::Color newColor = colordlg.get_colorsel()->get_current_color();
        gchar buf[1024] = {0};
        
        memset(buf, '\0', sizeof(buf));
        snprintf(buf, sizeof(buf) -1, "#%02X%02X%02X", 
            (int)rint(newColor.get_red_p() * 0xff),
            (int)rint(newColor.get_green_p() * 0xff),
            (int)rint(newColor.get_blue_p() * 0xff));
        m_cBackground.set_text(buf);
    }
}

/**
 * ʿ
 */
void FusenshiEditDialog::on_foreground_clicked()
{
    Gtk::ColorSelectionDialog colordlg;
    
    colordlg.set_title(_("Foreground Color:"));
    colordlg.set_transient_for(*this);
    colordlg.get_help_button()->hide();

    Gdk::Color fgColor;
    fgColor.parse(m_cForeground.get_text());
    colordlg.get_colorsel()->set_current_color(fgColor);
    
    if (Gtk::RESPONSE_OK == colordlg.run()) {
        Gdk::Color newColor = colordlg.get_colorsel()->get_current_color();
        gchar buf[1024] = {0};
        
        memset(buf, '\0', sizeof(buf));
        snprintf(buf, sizeof(buf) -1, "#%02X%02X%02X", 
            (int)rint(newColor.get_red_p() * 0xff),
            (int)rint(newColor.get_green_p() * 0xff),
            (int)rint(newColor.get_blue_p() * 0xff));
        m_cForeground.set_text(buf);
    }
}

/**
 * եȤ
 */
void FusenshiEditDialog::on_fontname_clicked()
{
    Gtk::FontSelectionDialog fontdlg;
    
    fontdlg.set_title(_("Font:"));
    fontdlg.set_transient_for(*this);
    fontdlg.get_apply_button()->hide();
    
    fontdlg.get_font_selection()->set_font_name(m_cFontName.get_text());
    
    if (Gtk::RESPONSE_OK == fontdlg.run()) {
        m_cFontName.set_text(fontdlg.get_font_selection()->get_font_name());
    }
}
