/*
 * $Id: fusenshieditdialog.h,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#ifndef ___FUSENSHIEDITDIALOG_H
#define ___FUSENSHIEDITDIALOG_H

#include <gtkmm.h>
#include "../include/fusenshidata.h"

class FusenshiEditDialog : public Gtk::Dialog
{
public:
    /**
     * 󥹥ȥ饯
     */
    FusenshiEditDialog(const FusenshiData* pData);
    
    /**
     * ǥȥ饯
     */
    ~FusenshiEditDialog();
    
    /**
     * ⡼Ȥɽޤ
     * 
     * @return 쥹ݥ
     */
    gint doModal();
    
    /**
     * 䵻ǡޤ
     * 
     * @return 䵻ǡ
     */
    const FusenshiData& getNewData();
    
    /**
     * ǡѹ̵ͭåޤ
     * 
     * @return ѹ true ᤷޤ
     */
    bool isChanged();
    
protected:
    /**
     * ɥκ׵ޤ
     */
    virtual bool on_delete_event(GdkEventAny* pEvent);

    /**
     * 쥹ݥ
     */
    virtual void on_response(int nResponse);

    /**
     * طʿ
     */
    virtual void on_background_clicked();
    
    /**
     * ʿ
     */
    virtual void on_foreground_clicked();
    
    /**
     * եȤ
     */
    virtual void on_fontname_clicked();
    
private:
    /**
     * ꥸʥ䵻ǡ
     */
    const FusenshiData* m_pOriginalData;
    
    /**
     * 䵻ǡ
     */
    FusenshiData m_cData;
    
    /**
     * 쥹ݥ
     */
    int m_nResponse;
    
    /**
     * ƥȥӥ塼
     */
    Gtk::TextView m_cTextView;
    
    /**
     * طʿȥ
     */
    Gtk::Entry m_cBackground;
    
    /**
     * ʿȥ
     */
    Gtk::Entry m_cForeground;
    
    /**
     * ե̾ȥ
     */
    Gtk::Entry m_cFontName;
};

#endif
