/*
 * $Id: fusenshimainwnd.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshimainwnd.h"
#include "fusenshiwnd.h"
#include "wndservice.h"
#include "propertydialog.h"
#include "../misc/resourceloader.h"

/**
 * 󥹥ȥ饯
 */
FusenshiMainWnd::FusenshiMainWnd()
{
    Glib::RefPtr<Gdk::Pixbuf> gPixbuf;
    Gtk::Image *pImage = NULL;
    
    // ɥ
    set_title(_("Fusenshi Main Window"));
    set_wmclass(APP_NAME, "FusenshiMain");
    set_size_request(TOP_WINDOW_WIDTH, TOP_WINDOW_HEIGHT);
    set_resizable(FALSE);
    property_destroy_with_parent() = true;

    try {
        gPixbuf = ResourceLoader::createPixbuf("fusenshi.xpm");
        set_icon(gPixbuf);
        gPixbuf.clear();
    }
    catch (...) {
        fprintf(stderr, "%s: Can't load pixbuf.\n", APP_NAME);
    }

    m_cButton.show();
    add(m_cButton);

    try {
        pImage = manage(ResourceLoader::createImage("fusenshi.xpm"));
        if (pImage) {
            pImage->show();
            m_cButton.add(*pImage);
        }
    }
    catch (...) {
        fprintf(stderr, "%s: Can't load image.\n", APP_NAME);
    }
    
    m_cButton.signal_clicked().connect
        (SigC::slot(*this, &FusenshiMainWnd::on_button_clicked));
    m_cButton.signal_button_release_event().connect
        (SigC::slot(*this, &FusenshiMainWnd::on_button_release_event), false);
}

/**
 * ǥȥ饯
 */
FusenshiMainWnd::~FusenshiMainWnd()
{
}

/**
 * ɥ
 */
bool FusenshiMainWnd::on_delete_event(GdkEventAny* pEvent)
{
    // 䵻楦ɥ˴
    WndService::getInstance()->destroyFusenshiWndAll();
    
    // ɥλ롣
    WndService::getInstance()->stop();
    
    return Gtk::Window::on_delete_event(pEvent);
}

void FusenshiMainWnd::on_button_clicked()
{
    // 䵻ο
    WndService::getInstance()->createFusenshi();
}

bool FusenshiMainWnd::on_button_release_event(GdkEventButton* pEvent)
{
    // å˱ơݥåץåץ˥塼ɽ
    if (pEvent->type == GDK_BUTTON_RELEASE && pEvent->button == 3) {
    	int count = 0;
        Gtk::Menu* pMenu = manage(new Gtk::Menu());

#define MENU_NUMBER     2
	    Glib::ustring pMenuLabels[MENU_NUMBER] = {
	    	Glib::ustring(_("Property")),
	    	Glib::ustring(_("Quit")),
	    };
	    SigC::Slot0<void> slots[MENU_NUMBER] = {
	        SigC::slot(*this, &FusenshiMainWnd::on_menu_property_activate),
	        SigC::slot(*this, &FusenshiMainWnd::on_menu_close_activate),
	    };
	    
	    // ƥ
	    Gtk::MenuItem* pMenuItem = NULL;
	    for (count = 0; count < MENU_NUMBER; count++) {
	        pMenuItem = manage(new Gtk::MenuItem(pMenuLabels[count]));
	        
	        pMenu->append(*pMenuItem);
	        
	        pMenuItem->signal_activate().connect(slots[count]);
	        pMenuItem->show();
	    }
#undef MENU_NUMBER

        pMenu->show();
        pMenu->popup(pEvent->button, pEvent->time);

        return true;
    }
    
    return false;
}

/**
 * ݥåץåץ˥塼Ρפα
 */
void FusenshiMainWnd::on_menu_property_activate()
{
    PropertyDialog dlg(WndService::getProperty());

    if (Gtk::RESPONSE_OK == dlg.doModal()) {
        WndService::setProperty(dlg.getNewData());
    }
}

/**
 * ݥåץåץ˥塼ΡĤפα
 */
void FusenshiMainWnd::on_menu_close_activate()
{
    on_delete_event(NULL);
}
