/*
 * $Id: fusenshiwnd.cpp,v 1.1 2004/04/01 08:53:26 daichi Exp $
 *
 * Copyright 2003- ONGS Inc. All rights reserved.
 * 
 * author: Masanori OZAWA (ozawa@ongs.co.jp)
 * version: $Revision: 1.1 $
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY ONGS INC ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ONGS INC OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the ONGS Inc.
 * 
 */

#include "../include/fusenshi.h"
#include "fusenshiwnd.h"
#include "wndservice.h"
#include "fusenshieditdialog.h"
#include "senddialog.h"
#include "entrydialog.h"
#include "../misc/resourceloader.h"

#include "X11/Xlib.h"
#include "gtk/gtk.h"
#include "gdk/gdkx.h"

#define FUSENSHI_INIT_FLAG      "initialize_flag"
#define FRAME_BORDER_WIDTH      5

static Glib::Quark g_cQuarkInitFlag(FUSENSHI_INIT_FLAG);

/**
 * 䵻楦ɥɸॿ
 */
WND_TYPE FusenshiWnd::m_nDefaultWndType = WND_TYPE_NORMAL;

/**
 * 󥹥ȥ饯
 */
FusenshiWnd::FusenshiWnd(FusenshiData *pData, guint nFileID)
{
    if (!pData) {
        throw "Null Pointer Exception.";
    }
    
    // Фν
    m_pData = pData;
    m_nFileID = nFileID;
    m_nWndType = m_nDefaultWndType;
    
    // ɥν
    set_wmclass(APP_NAME, "Fusenshi");
    set_title(_("Fusenshi"));
    set_border_width(0);
    set_skip_taskbar_hint(false);
    set_skip_pager_hint(true);
    property_destroy_with_parent() = true;
    
    try {
        Glib::RefPtr<Gdk::Pixbuf> gPixbuf;

        gPixbuf = ResourceLoader::createPixbuf("fusenshi.xpm");
        set_icon(gPixbuf);
        gPixbuf.clear();
    }
    catch (...) {
        fprintf(stderr, "%s: Can't load pixbuf.\n", APP_NAME);
    }

    // åȤι
    m_cTextView.unset_flags(Gtk::CAN_FOCUS);
    m_cTextView.set_editable(false);
    m_cTextView.set_cursor_visible(false);

    m_cScrolledWnd.set_policy
        (Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
    m_cScrolledWnd.add(m_cTextView);

    if (WND_TYPE_SIMPLE == m_nWndType) {
        add(m_cScrolledWnd);
    }
    else {
        m_cDrawingArea.set_size_request(WINDOW_TAG_WIDTH, 20);

        Gtk::Frame* pFrame = manage(new Gtk::Frame());
        pFrame->set_border_width(FRAME_BORDER_WIDTH);
        pFrame->set_shadow_type(Gtk::SHADOW_ETCHED_IN);
        pFrame->add(m_cScrolledWnd);

        m_cEventBox.add(*pFrame);

        Gtk::HBox* pHBox = manage(new Gtk::HBox(false, 0));
        pHBox->pack_start(m_cDrawingArea, false, false, 0);
        pHBox->pack_end(m_cEventBox, true, true, 0);

        add(*pHBox);
        
        m_cDrawingArea.signal_expose_event().connect
            (SigC::slot(*this, &FusenshiWnd::on_expose_event));
        
        m_cDrawingArea.add_events(Gdk::BUTTON_PRESS_MASK);
        m_cDrawingArea.signal_button_press_event().connect
            (SigC::slot(*this, &FusenshiWnd::on_tag_press_event));

        m_cEventBox.set_events(Gdk::BUTTON_PRESS_MASK);
        m_cEventBox.signal_button_press_event().connect
            (SigC::slot(*this, &FusenshiWnd::on_frame_press_event));
    }

    m_cTextView.signal_populate_popup().connect
        (SigC::slot(*this, &FusenshiWnd::on_populate_popup));
    
    // 䵻極Ĵ
    if (WINDOW_TAG_WIDTH > m_pData->getWidth()) {
        m_pData->setWidth(WINDOW_TAG_WIDTH);
    }
    if (10 > m_pData->getHeight()) {
        m_pData->setHeight(10);
    }
    
    // 䵻֤Ĵ
    const guint maxWidth = gdk_screen_width() - m_pData->getWidth();
    const guint maxHeight = gdk_screen_height() - m_pData->getHeight();
    
    if (0 > m_pData->getXPos()) {
        m_pData->setXPos(0);
    }
    else if (m_pData->getXPos() >= maxWidth) {
        m_pData->setXPos(maxWidth);
    }

    if (0 > m_pData->getYPos()) {
        m_pData->setYPos(0);
    }
    else if (m_pData->getYPos() >= maxHeight) {
        m_pData->setYPos(maxHeight);
    }
    
    // ɽ
    set_default_size(m_pData->getWidth(), m_pData->getHeight());
    set_size_request(m_pData->getWidth(), m_pData->getHeight());
    
    // ɽ
    refresh();
    show_all_children();
}

/**
 * ɽ줿Ȥν
 */
void FusenshiWnd::on_show()
{
    Gtk::Window::on_show();

    // ޥݥ󥿤
    if (WND_TYPE_NORMAL == m_nWndType) {
        Gdk::Cursor moveCursor(Gdk::FLEUR);
        Gdk::Cursor resizeCursor(Gdk::SIZING);

        m_cDrawingArea.get_window()->set_cursor(moveCursor);
        m_cEventBox.get_window()->set_cursor(resizeCursor);
    }
}

/**
 * ǥȥ饯
 */
FusenshiWnd::~FusenshiWnd()
{
    if (m_pData) {
        delete m_pData;
        m_pData = NULL;
    }
}

/**
 * 䵻ꤷޤ
 */
void FusenshiWnd::refresh()
{
    // 
    set_data(g_cQuarkInitFlag, (gpointer)0);

    m_cTextView.set_left_margin(5);
    m_cTextView.set_right_margin(5);

    if (WND_TYPE_NORMAL == m_nWndType) {
        // ȥСӤ¾ɽˤ
        set_decorated(false);
    }

    property_allow_shrink() = true;
    property_allow_grow() = true;

    // ɥꤹ
    resize(m_pData->getWidth(), m_pData->getHeight());
    
    // ɥư
    move(m_pData->getXPos(), m_pData->getYPos());
    
     // طʿ
    Gdk::Color bgColor((GdkColor*)m_pData->getBackground(), true);
    modify_bg(Gtk::STATE_NORMAL, bgColor);
    m_cEventBox.modify_bg(Gtk::STATE_NORMAL, bgColor);
    m_cTextView.modify_base(Gtk::STATE_NORMAL, bgColor);
    // ʿ
    Gdk::Color fgColor((GdkColor*)m_pData->getForeground(), true);
    m_cTextView.modify_text(Gtk::STATE_NORMAL, fgColor);

    // եȤ
    Pango::FontDescription* pFont = 
        new Pango::FontDescription(m_pData->getFontName().c_str());
    m_cTextView.modify_font(*pFont);
    delete pFont;

    // ̤ɽ
    guint nStyle = m_pData->getStyle();
    if (nStyle & GDK_WINDOW_STATE_ICONIFIED) {
        // Ǿ
        iconify();
    }
    else if (nStyle & GDK_WINDOW_STATE_MAXIMIZED) {
        // 粽
        maximize();
    }
    else if (nStyle & GDK_WINDOW_STATE_STICKY) {
        // ˤ(ȥСΤߤˤ)
        stick();
    }

    // ƥȤ
    Glib::RefPtr<Gtk::TextBuffer> textBuffer =
        m_cTextView.get_buffer();
    textBuffer->set_text(m_pData->getText().c_str());

    // λե饰ΩƤ
    set_data(g_cQuarkInitFlag, (gpointer)1);
}

/**
 * XWindowSystemľܥɥ֤ޤ
 */
int FusenshiWnd::getXLibWindowStyle()
{
    int result = 0; // normal window
    Glib::RefPtr<Gdk::Window> window = get_window();
    GdkWindow *pWindow = window->gobj();

    XWindowAttributes attributes;
    memset(&attributes, 0, sizeof(attributes));
    attributes.map_state = IsUnviewable;

    if (XGetWindowAttributes
        (GDK_WINDOW_XDISPLAY(pWindow),
         GDK_WINDOW_XWINDOW(pWindow), &attributes))
    {
        if (attributes.map_state == IsUnviewable) {
            result = GDK_WINDOW_STATE_ICONIFIED;
        }
        else {
            result = window->get_state();
        }
    }

    return result;
}

/**
 * 䵻楦ɥɸॿפꤷޤ
 * 
 * @param nWndType 䵻楦ɥɸॿ
 */
void FusenshiWnd::setDefaultWindowType(WND_TYPE nWndType)
{
    m_nDefaultWndType = nWndType;
}

/**
 * 䵻κ٥Ȥޤ
 */
bool FusenshiWnd::on_delete_event(GdkEventAny* pEvent)
{
    // 䵻ǧ
    Gtk::MessageDialog dialog
        (_("May I delete this note?"),
         Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_OK_CANCEL, true, false);

    if (Gtk::RESPONSE_OK == dialog.run()) {
        // 䵻եκ׵
        WndService::getInstance()->deleteFusenshi(m_nFileID);
        WndService::getInstance()->destroyFusenshiWnd(this);

        Gtk::Window::on_delete_event(pEvent);

        return false;
    }

    return true;
}

/**
 * Խɽ
 */
void FusenshiWnd::on_edit()
{
    FusenshiEditDialog editdlg(m_pData);
    
    editdlg.set_transient_for(*this);
    
    if (Gtk::RESPONSE_OK == editdlg.doModal()) {
        if (editdlg.isChanged()) {
            *m_pData = editdlg.getNewData();

            // ѹŬ
            refresh();
            
            // ¸
            WndService::getInstance()->saveFusenshi(m_nFileID, m_pData);
        }
    }
}

/**
 * 粽
 */
void FusenshiWnd::on_maximize()
{
    int style = getXLibWindowStyle();

    if (style & GDK_WINDOW_STATE_MAXIMIZED) {
        // 粽
        unmaximize();
    }
    else {
        // 粽
        maximize();
    }
}

/**
 * Ǿ
 */
void FusenshiWnd::on_minimize()
{
    int style = getXLibWindowStyle();

    if (style & GDK_WINDOW_STATE_ICONIFIED) {
        // Ǿ
        deiconify();
    }
    else {
        // Ǿ
        iconify();
    }
}

/**
 * ׵
 */
void FusenshiWnd::on_send()
{
    SendDialog senddlg;
    
    senddlg.set_transient_for(*this);
    
    if (Gtk::RESPONSE_OK == senddlg.run()) {
        // 
        bool bSend = FusenshiClient::sendFusenshiData
            (senddlg.getServerList(), *m_pData,
             WndService::getProperty().getNickName());

        if (!bSend) {
            Gtk::MessageDialog msgDlg
                (_("Transmission of the sticky note went wrong.\n"), 
                 Gtk::MESSAGE_WARNING, Gtk::BUTTONS_OK, true, false);
            
            msgDlg.set_transient_for(*this);
            
            msgDlg.run();
        }
    }
}

/**
 * ׵
 */
void FusenshiWnd::on_print()
{
    EntryDialog dlg(_("Fusenshi - Print"));
    PropertyData property = WndService::getProperty();
    
    dlg.setEntryLabel(_("Print command:"));
    dlg.setMessageLabel(_("    %1: Exchange to print file."));
    dlg.set_default_size(300, 120);
    dlg.setText(property.getPrintCommand());

    if (Gtk::RESPONSE_OK == dlg.doModal()) {
        // ׵
        Glib::ustring command = dlg.getText();
        WndService::getInstance()->printFusenshi(m_nFileID, command);
    }
}

/**
 * ׵
 */
void FusenshiWnd::on_delete()
{
    on_delete_event(NULL);
}

/**
 * ݥåץåץ˥塼ɽ
 */
void FusenshiWnd::on_populate_popup(Gtk::Menu* pMenu)
{
    // 䵻Υݥåץåץ˥塼򥫥ޥ
    int count = 0;
    
#define MENU_NUMBER     6
    Glib::ustring pMenuLabels[MENU_NUMBER] = {
        Glib::ustring(_("Edit")),
        Glib::ustring(_("Send")),
        Glib::ustring(_("Print")),
        Glib::ustring(_("Maximize")),
        Glib::ustring(_("Minimize")),
        Glib::ustring(_("Delete"))
    };
    SigC::Slot0<void> slots[MENU_NUMBER] = {
        SigC::slot(*this, &FusenshiWnd::on_edit),
        SigC::slot(*this, &FusenshiWnd::on_send),
        SigC::slot(*this, &FusenshiWnd::on_print),
        SigC::slot(*this, &FusenshiWnd::on_maximize),
        SigC::slot(*this, &FusenshiWnd::on_minimize),
        SigC::slot(*this, &FusenshiWnd::on_delete)
    };
    const int sepPos[] = {
        5, 3, 0 // ߽ǻꤹ
    };
    
    // ¸Υƥ
    std::list<Widget*> pList = pMenu->get_children();
    std::list<Widget*>::iterator pIter;
    
    for (pIter = pList.begin(); pIter != pList.end(); pIter++) {
        pMenu->remove(**pIter);
    }

    // ƥ
    Gtk::MenuItem* pMenuItem = NULL;
    PropertyData property = WndService::getProperty();
    
    for (count = 0; count < MENU_NUMBER; count++) {
        pMenuItem = manage(new Gtk::MenuItem(pMenuLabels[count]));

        pMenu->append(*pMenuItem);
        
        pMenuItem->signal_activate().connect(slots[count]);
        pMenuItem->show();

        // ͥåȥ̵ͭ
        if (1 == count && !property.isEnableNetwork()) {
            pMenuItem->set_sensitive(false);
        }
    }
#undef MENU_NUMBER

    // ѥ졼ɲ
    for (count = 0; 0 < sepPos[count]; count++) {
        pMenuItem = manage(new Gtk::MenuItem());

        pMenu->insert(*pMenuItem, sepPos[count]);
        pMenuItem->show();
    }
}

/**
 * ɥΰ֡ѹα
 */
bool FusenshiWnd::on_configure_event(GdkEventConfigure* pEvent)
{
    // λե饰å
    int bInit = (int)get_data(g_cQuarkInitFlag);

    if (bInit && 0 == getXLibWindowStyle()) {
        int nX, nY, nWidth, nHeight;
        
        // ɥݥ
        get_position(nX, nY);

        // ɥ
        get_size(nWidth, nHeight);

        // ¸׵᤹
        m_pData->setXPos(nX);
        m_pData->setYPos(nY);
        m_pData->setWidth(nWidth);
        m_pData->setHeight(nHeight);
        WndService::getInstance()->saveFusenshi(m_nFileID, m_pData);
    }

    // ɥηĴ
    drawWindowShape();
  
    return Gtk::Window::on_configure_event(pEvent);
}

/**
 * ɥξѹα
 */
bool FusenshiWnd::on_window_state_event(GdkEventWindowState* pEvent)
{
    if (GDK_WINDOW_STATE == pEvent->type) {
        // λե饰å
        int bInit = (int)get_data(g_cQuarkInitFlag);

        if (bInit) {
            // ɥ
            int style = getXLibWindowStyle();

            // ¸
            m_pData->setStyle(style);
            WndService::getInstance()->saveFusenshi(m_nFileID, m_pData);
        }
    }

    return Gtk::Window::on_window_state_event(pEvent);
}

/**
 * GtkDrawingArea
 */
bool FusenshiWnd::on_expose_event(GdkEventExpose* pEvent)
{
    bool result = Gtk::Window::on_expose_event(pEvent);

    if (WND_TYPE_NORMAL != m_nWndType) {
        return result;
    }

    GtkWidget* pWidget = GTK_WIDGET(m_cDrawingArea.gobj());
    GdkWindow* pWindow = pWidget->window;
    GdkGC* pGC = pWidget->style->fg_gc[GTK_WIDGET_STATE(pWidget)];
    gint width, height;
    
    gdk_drawable_get_size(GDK_DRAWABLE(pWindow), &width, &height);
    
    // ߤХåå
    GdkGCValues gcValues;
    
    gdk_gc_get_values(pGC, &gcValues);
    
    // طʿɤ٤
    gdk_gc_set_function(pGC, GDK_COPY);
    gdk_gc_set_rgb_fg_color(pGC, (GdkColor*)m_pData->getBackground());
    gdk_draw_rectangle(GDK_DRAWABLE(pWindow), pGC, TRUE, 
                       0, 0, width, height);

    // 
    gdk_gc_set_function(pGC, gcValues.function);
    gdk_gc_set_foreground(pGC, &gcValues.foreground);
    
    return result;
}

/**
 * ɥ褹
 */
void FusenshiWnd::drawWindowShape()
{
    if (WND_TYPE_SIMPLE == m_nWndType) {
        return;
    }
    
    int width = 0;
    int height = 0;
    gchar *bmpData = NULL;
    GdkBitmap *bitmap = NULL;
    GdkPoint points[6];
    GdkGC *gc = NULL;
    GdkColor black = {0, 0, 0, 0};
    GdkColor white = {0xffff, 0xffff, 0xffff, 0xffff};
    GtkWidget* pWidget = GTK_WIDGET(gobj());

    gdk_drawable_get_size(pWidget->window, &width, &height);

    bmpData = (gchar*)g_malloc0(((width + 7) / 8) * height);

    if (!bmpData) {
        fprintf(stderr, "%s: Out of Memory Error!\n", APP_NAME);
    }

    // ӥåȥޥåפ
    bitmap = gdk_bitmap_create_from_data(pWidget->window, bmpData,
                                         width, height);

    points[0].x = 0;
    points[0].y = height /2;
    points[1].x = WINDOW_TAG_WIDTH;
    points[1].y = 0;
    points[2].x = width;
    points[2].y = 0;
    points[3].x = width;
    points[3].y = height;
    points[4].x = WINDOW_TAG_WIDTH;
    points[4].y = height;
    points[5].x = 0;
    points[5].y = height /2;

    gc = gdk_gc_new(bitmap);

    // Ѥ䵻
    gdk_gc_set_foreground(gc, &white);
    gdk_draw_polygon(bitmap, gc, TRUE, points, 6);

    // 򳫤
    gdk_gc_set_foreground(gc, &black);
    int tagWidth = WINDOW_TAG_WIDTH / 2;
    gdk_draw_arc(bitmap, gc, TRUE,
                 tagWidth / 2, (height / 2) - (tagWidth / 2),
                 tagWidth, tagWidth, 0, 360 * 64);

    g_object_unref(gc);

    // ɥѹ
    gdk_window_shape_combine_mask(pWidget->window, bitmap, 0, 0);

    // 
    g_object_unref(bitmap);
    g_free(bmpData);
}

/**
 * ΰΥޥܥβ˱
 */
bool FusenshiWnd::on_tag_press_event(GdkEventButton* pEvent)
{
    if (GDK_BUTTON_PRESS == pEvent->type && 1 == pEvent->button) {
        // ɥΰư򳫻
        begin_move_drag
            (1, (int)pEvent->x_root, (int)pEvent->y_root, pEvent->time);

        return true;
    }

    return false;
}

/**
 * ե졼ΰΥޥܥβ˱
 */
bool FusenshiWnd::on_frame_press_event(GdkEventButton* pEvent)
{
    if (GDK_BUTTON_PRESS == pEvent->type && 1 == pEvent->button) {
        // ե졼ΰ֤Ĵ٤
        const int x = (int)pEvent->x;
        const int y = (int)pEvent->y;
        int width = 0;
        int height = 0;
        int borderWidth = 0;
        int borderHeight = 0;
        GtkWidget *pWidget = GTK_WIDGET(m_cTextView.gobj());

        gdk_drawable_get_size(GDK_DRAWABLE(pEvent->window), &width, &height);
        gdk_window_get_position
            (GDK_DRAWABLE(pWidget->window), &borderWidth, &borderHeight);
        
        Gdk::WindowEdge edge;
        if (borderWidth > x) {
            if (borderHeight > y) {
                edge = Gdk::WINDOW_EDGE_NORTH_WEST;
            }
            else if ((height - borderHeight) < y) {
                edge = Gdk::WINDOW_EDGE_SOUTH_WEST;
            }
            else {
                edge = Gdk::WINDOW_EDGE_WEST;
            }
        }
        else if ((width - borderWidth) < x) {
            if (borderHeight > y) {
                edge = Gdk::WINDOW_EDGE_NORTH_EAST;
            }
            else if ((height - borderHeight) < y) {
                edge = Gdk::WINDOW_EDGE_SOUTH_EAST;
            }
            else {
                edge = Gdk::WINDOW_EDGE_EAST;
            }
        }
        else {
            if (borderHeight > y) {
                edge = Gdk::WINDOW_EDGE_NORTH;
            }
            else {
                edge = Gdk::WINDOW_EDGE_SOUTH;
            }
        }

        // ɥΰư򳫻
        begin_resize_drag
            (edge, 1, (int)pEvent->x_root, (int)pEvent->y_root, pEvent->time);

        return true;
    }

    return false;
}
